/*
 * Decompiled with CFR 0.152.
 */
package uartjsscadapter;

import com.microchip.scf.CommunicationsInterface;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import jssc.SerialPort;
import jssc.SerialPortEvent;
import jssc.SerialPortEventListener;
import jssc.SerialPortException;
import jssc.SerialPortList;
import jssc.SerialPortTimeoutException;

public class JSSCSerialPortAdapter
implements CommunicationsInterface {
    InputStream uartInputStream;
    OutputStream uartOutputStream;
    int toolIndex = -1;
    String deviceName;
    SerialPort serialDevice = null;
    public int baudRate = 57600;
    public int dataBits = 8;
    public int stopBits = 1;
    public boolean parity = false;
    boolean isDeviceConnected = false;
    int timeoutMS;
    protected static String[] protNames = null;
    private static final Logger LOGGER = Logger.getLogger(JSSCSerialPortAdapter.class.getName());

    private void getDeviceIndexFromToolMap() {
        for (String str : protNames) {
            if (!str.contains(this.deviceName)) continue;
            this.serialDevice = new SerialPort(str);
        }
    }

    public synchronized void setParams() {
        block5: {
            try {
                if (this.serialDevice != null) {
                    this.serialDevice.setFlowControlMode(0);
                    if (this.parity) {
                        this.serialDevice.setParams(this.baudRate, this.dataBits, this.stopBits, 1);
                    } else {
                        this.serialDevice.setParams(this.baudRate, this.dataBits, this.stopBits, 0);
                    }
                    break block5;
                }
                LOGGER.log(Level.SEVERE, "__rawConnect : Port not enumerated");
                throw new RuntimeException("__rawConnect : Port not enumerated");
            }
            catch (SerialPortException ex) {
                LOGGER.log(Level.SEVERE, "__rawConnect : Port not enumerated" + ex.toString(), ex);
                throw new RuntimeException("__rawConnect : Port not enumerated");
            }
        }
    }

    public void setBaudRate(int baudRate) {
        this.baudRate = baudRate;
        this.setParams();
    }

    public int getBaudRate() {
        return this.baudRate;
    }

    public void setParity(boolean parity) {
        this.parity = parity;
        this.setParams();
    }

    public boolean getParity() {
        return this.parity;
    }

    public void setStopBits(int stopBits) {
        this.stopBits = stopBits;
        this.setParams();
    }

    public int getStopBits() {
        return this.stopBits;
    }

    public void setStartBits(int startBits) {
        this.dataBits = startBits;
        this.setParams();
    }

    public int getStartBits() {
        return this.dataBits;
    }

    public String[] getAttachedDevices() throws IOException {
        protNames = SerialPortList.getPortNames();
        return protNames;
    }

    public boolean connect() throws IOException {
        try {
            this.getDeviceIndexFromToolMap();
            if (this.serialDevice == null) {
                LOGGER.log(Level.SEVERE, "__rawConnect : Port not enumerated");
                throw new RuntimeException("__rawConnect : Port not enumerated");
            }
            boolean success = this.serialDevice.openPort();
            if (success) {
                this.setParams();
                this.serialDevice.addEventListener((SerialPortEventListener)new SerialPortReader());
                this.serialDevice.purgePort(12);
                this.isDeviceConnected = true;
                this.uartInputStream = new UARTInputStream();
                this.uartOutputStream = new UARTOutputStream();
                return true;
            }
            this.isDeviceConnected = false;
            return false;
        }
        catch (SerialPortException ex) {
            LOGGER.log(Level.SEVERE, "Failed to Connect via JSSC" + ex.toString(), ex);
            throw new IOException(ex);
        }
    }

    public boolean disconnect() throws IOException {
        this.uartInputStream.close();
        this.uartOutputStream.close();
        if (this.serialDevice != null) {
            try {
                this.serialDevice.removeEventListener();
                boolean success = this.serialDevice.closePort();
                if (success) {
                    this.isDeviceConnected = false;
                    return true;
                }
                this.isDeviceConnected = true;
                return false;
            }
            catch (SerialPortException ex) {
                LOGGER.log(Level.SEVERE, "Failed to Disconnect via JSSC" + ex.toString(), ex);
                throw new IOException(ex);
            }
        }
        return false;
    }

    public InputStream getInputStream() throws IOException {
        if (this.uartInputStream != null) {
            return this.uartInputStream;
        }
        LOGGER.log(Level.SEVERE, "Device not opened. Please initialize the device.");
        throw new IOException("Device not opened. Please initialize the device.");
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.uartOutputStream != null) {
            return this.uartOutputStream;
        }
        LOGGER.log(Level.SEVERE, "Device not opened. Please initialize the device.");
        throw new IOException("Device not opened. Please initialize the device.");
    }

    public void setDeviceName(String name) {
        this.deviceName = name;
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public void setTimeOut(int timeOutinSeconds) {
        this.timeoutMS = timeOutinSeconds;
    }

    public boolean isOpen() {
        return this.isDeviceConnected;
    }

    private class UARTOutputStream
    extends OutputStream {
        private UARTOutputStream() {
        }

        @Override
        public void write(int b) throws IOException {
            try {
                boolean success = JSSCSerialPortAdapter.this.serialDevice.writeByte((byte)b);
                if (!success) {
                    LOGGER.log(Level.SEVERE, "Write Failed");
                    throw new IOException("Write Failed");
                }
            }
            catch (SerialPortException ex) {
                LOGGER.log(Level.SEVERE, "Write Failed. SerialPortException occured.", ex);
                throw new IOException("Write Failed. SerialPortException occured.", ex);
            }
        }

        @Override
        public void write(byte[] b) throws IOException {
            try {
                boolean success = JSSCSerialPortAdapter.this.serialDevice.writeBytes(b);
                if (!success) {
                    LOGGER.log(Level.SEVERE, "Write Failed");
                    throw new IOException("Write Failed");
                }
            }
            catch (SerialPortException ex) {
                LOGGER.log(Level.SEVERE, "Write Failed. SerialPortException occured.", ex);
                throw new IOException("Write Failed. SerialPortException occured.", ex);
            }
        }

        @Override
        public void close() throws IOException {
        }
    }

    private class UARTInputStream
    extends InputStream {
        private UARTInputStream() {
        }

        @Override
        public int read() throws IOException {
            try {
                byte[] dataReceived = JSSCSerialPortAdapter.this.serialDevice.readBytes(1, JSSCSerialPortAdapter.this.timeoutMS);
                return dataReceived[0] & 0xFF;
            }
            catch (SerialPortException | SerialPortTimeoutException ex) {
                LOGGER.log(Level.SEVERE, "Serial Port Exception on InputStream Read" + ex.toString(), ex);
                throw new IOException(ex);
            }
        }

        @Override
        public int read(byte[] b) throws IOException {
            try {
                byte[] dataReceived = JSSCSerialPortAdapter.this.serialDevice.readBytes(b.length, JSSCSerialPortAdapter.this.timeoutMS);
                System.arraycopy(dataReceived, 0, b, 0, dataReceived.length);
                return dataReceived.length;
            }
            catch (SerialPortException | SerialPortTimeoutException ex) {
                LOGGER.log(Level.SEVERE, "Serial Port Exception on InputStream Read" + ex.toString(), ex);
                throw new IOException(ex);
            }
        }

        @Override
        public void close() throws IOException {
        }
    }

    private class SerialPortReader
    implements SerialPortEventListener {
        private SerialPortReader() {
        }

        public void serialEvent(SerialPortEvent event) {
            String s = String.format("Event Type: %s.Event Value: %s.Port Name: %s", event.getEventType(), event.getEventValue(), event.getPortName());
            LOGGER.log(Level.FINE, s, event);
        }
    }
}

