/*
 * Decompiled with CFR 0.152.
 */
package usbhid4javaserviceprovider;

import com.microchip.scf.CommunicationsInterface;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.event.Event;
import javafx.event.EventType;
import org.hid4java.HidDevice;
import org.hid4java.HidManager;
import org.hid4java.HidServices;
import org.hid4java.HidServicesListener;
import org.hid4java.event.HidServicesEvent;

public class Hid4JavaUSBAdapter
implements CommunicationsInterface {
    InputStream inputPipe;
    OutputStream outputPipe;
    int toolIndex = -1;
    String deviceName;
    HidDevice hidDevice = null;
    boolean isDeviceConnected = false;
    int timeOutMS;
    protected static String[] protNames = null;
    protected static ObservableList<Event> deviceListObserver = FXCollections.observableArrayList();
    private static final Logger LOGGER = Logger.getLogger(Hid4JavaUSBAdapter.class.getName());
    HidServicesListener listenAttach = new HidServicesListener(){
        int eventID = 0;

        public void hidDeviceAttached(HidServicesEvent hse) {
            deviceListObserver.add((Object)new Event((Object)String.format("%02X", hse.getHidDevice().getProductId()), null, new EventType(this.eventID++ + " Attach")));
        }

        public void hidDeviceDetached(HidServicesEvent hse) {
            deviceListObserver.add((Object)new Event((Object)String.format("%02X", hse.getHidDevice().getProductId()), null, new EventType(this.eventID++ + " Detach")));
        }

        public void hidFailure(HidServicesEvent hse) {
            Event event = new Event((Object)String.format("%02X", hse.getHidDevice().getProductId()), null, new EventType(this.eventID + " Failure"));
            deviceListObserver.add((Object)event);
            System.err.println(hse.toString());
        }
    };

    public int getPid() {
        return this.hidDevice.getProductId();
    }

    public int getVid() {
        return this.hidDevice.getVendorId();
    }

    public void addDeviceListObserver(ListChangeListener<? super Event> event) {
        deviceListObserver.addListener(event);
    }

    public void removeDeviceListObserver(ListChangeListener<? super Event> event) {
        deviceListObserver.removeListener(event);
    }

    private void getDeviceIndexFromToolMap() {
        for (HidDevice dev : HidManager.getHidServices().getAttachedHidDevices()) {
            if (!String.format("%02X", dev.getProductId()).contains(this.deviceName)) continue;
            this.hidDevice = dev;
        }
    }

    public String[] getAttachedDevices() throws IOException {
        HidManager.getHidServices().addHidServicesListener(this.listenAttach);
        ArrayList<String> deviceList = new ArrayList<String>();
        HidServices hidServices = HidManager.getHidServices();
        for (HidDevice device : hidServices.getAttachedHidDevices()) {
            deviceList.add(String.format("%02X", device.getProductId()));
        }
        String[] deviceListArray = new String[deviceList.size()];
        for (int i = 0; i < deviceListArray.length; ++i) {
            deviceListArray[i] = (String)deviceList.get(i);
        }
        protNames = deviceListArray;
        return deviceListArray;
    }

    public boolean connect() throws IOException {
        this.getDeviceIndexFromToolMap();
        if (this.hidDevice == null) {
            LOGGER.log(Level.SEVERE, "__rawConnect : Port not enumerated");
            throw new RuntimeException("__rawConnect : Port not enumerated");
        }
        boolean success = this.hidDevice.open();
        if (success) {
            this.isDeviceConnected = true;
            this.inputPipe = new USBInputStream();
            this.outputPipe = new USBOutputStream();
        } else {
            this.isDeviceConnected = false;
        }
        return success;
    }

    public boolean disconnect() throws IOException {
        this.inputPipe.close();
        this.outputPipe.close();
        boolean tRes = true;
        if (this.hidDevice != null) {
            this.hidDevice.close();
        }
        this.isDeviceConnected = false;
        return tRes;
    }

    public InputStream getInputStream() throws IOException {
        if (this.inputPipe != null) {
            return this.inputPipe;
        }
        LOGGER.log(Level.SEVERE, "Device not opened. Please initialize the device.");
        throw new IOException("Device not opened. Please initialize the device.");
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.outputPipe != null) {
            return this.outputPipe;
        }
        LOGGER.log(Level.SEVERE, "Device not opened. Please initialize the device.");
        throw new IOException("Device not opened. Please initialize the device.");
    }

    public void setDeviceName(String name) {
        this.deviceName = name;
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public void setTimeOut(int timeOutinSeconds) {
        this.timeOutMS = timeOutinSeconds;
    }

    public boolean isOpen() {
        return this.isDeviceConnected;
    }

    private class USBOutputStream
    extends OutputStream {
        private USBOutputStream() {
        }

        @Override
        public void write(byte[] b) throws IOException {
            int success;
            if (System.getProperty("os.name").contains("Windows")) {
                byte[] windowsGrossFix = new byte[65];
                windowsGrossFix[0] = 0;
                System.arraycopy(b, 0, windowsGrossFix, 1, 64);
                success = Hid4JavaUSBAdapter.this.hidDevice.write(windowsGrossFix, 65, (byte)0);
            } else {
                success = Hid4JavaUSBAdapter.this.hidDevice.write(b, 64, (byte)0);
            }
            if (success <= 0) {
                LOGGER.log(Level.FINE, "Error Message reportted by hid4java: " + Hid4JavaUSBAdapter.this.hidDevice.getLastErrorMessage(), Hid4JavaUSBAdapter.this.hidDevice.getLastErrorMessage());
                throw new IOException(Hid4JavaUSBAdapter.this.deviceName);
            }
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public void write(int b) throws IOException {
            LOGGER.log(Level.SEVERE, "Not supported yet.");
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            LOGGER.log(Level.SEVERE, "Not supported yet.");
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    private class USBInputStream
    extends InputStream {
        private USBInputStream() {
        }

        @Override
        public int read(byte[] b) throws IOException {
            if (b == null) {
                throw new NullPointerException();
            }
            int dataReceived = Hid4JavaUSBAdapter.this.hidDevice.read(b, Hid4JavaUSBAdapter.this.timeOutMS);
            LOGGER.log(Level.FINE, "Bytes received for transaction" + dataReceived, dataReceived);
            return dataReceived;
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public int read() throws IOException {
            LOGGER.log(Level.SEVERE, "Not supported yet. Each HID packet should be 64 bytes.");
            throw new UnsupportedOperationException("Not supported yet. Each HID packet should be 64 bytes.");
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            LOGGER.log(Level.SEVERE, "Not supported yet.");
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public long skip(long n) throws IOException {
            LOGGER.log(Level.SEVERE, "Not supported yet.");
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

