/*
 * Decompiled with CFR 0.152.
 */
package i2cBootloaderController;

import exceptionclasses.ValidationException;
import i2cBootloaderController.ACommandBaseExtendedWithDataPayloadAVR;
import i2cBootloaderModel.CommandModelWrite;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import packetprocessor.AVR_PacketProcessorEraseNoDataPayloadUART;
import protocol.nextchunkgetter.GetNextEraseAddress;
import readFileModel.MemoryModel;

public class CommandEraseDeviceUART_AVR
extends ACommandBaseExtendedWithDataPayloadAVR {
    static final byte BOOTLOADER_CMD = 3;
    static final int CMD_SUCCESS_RESPONSE = 1;
    static final int CMD_SUCCESS_SPECIAL = 2;
    static final int CMD_OUT_OF_RANGE_RESPONSE = 254;
    static final int CMD_NOT_SUPPORTED_RESPONSE = 253;
    private static final int CMD_LENGTH = 11;
    private static final int READ_CMD_LENGTH = 10;
    private static final int SYNCH_BYTE_POS = 0;
    private static final int CMD_BYTE_POS = 1;
    private static final int SYNCH_CHARACTER = 85;
    private static final int STATUS_BYTE_POS = 10;

    public CommandEraseDeviceUART_AVR(InputStream commsInputStream, OutputStream commsOutputStream, MemoryModel deviceMemoryModel) {
        this.bootloaderInputStream = commsInputStream;
        this.bootloaderOutputStream = commsOutputStream;
        this.deviceMemoryModel = deviceMemoryModel;
        this.setProcessReadDataAVR();
        this.setCommandModel(new CommandModelWrite());
        this.model.command = (byte)3;
        this.model.length = 0L;
        this.model.address = 0L;
        this.model.dataPayload = null;
        this.model.writeLength = 11;
        this.model.readLengthExpected = 11;
        this.model.allocateReadWriteBufferMemory();
    }

    @Override
    protected void setEraseChunckIterator() {
        this.addressIterator = new GetNextEraseAddress(this.deviceMemoryModel);
    }

    @Override
    public int validateLevel2() throws ValidationException {
        if (this.model.dataRead.length != this.model.readLengthExpected) {
            LOGGER.log(Level.SEVERE, "Bootloader Erase Response should be 10 bytes");
            throw new ValidationException("Bootloader Erase Response wrong size");
        }
        if (this.model.dataRead[0] != 85) {
            LOGGER.log(Level.SEVERE, "No Synch Byte before Response");
            throw new ValidationException("Malformed: No Synch Byte");
        }
        if (this.model.dataRead[1] != 3) {
            LOGGER.log(Level.SEVERE, "Bootloader Erase Command INCORRECT");
            throw new ValidationException("Malformed: Format not correct");
        }
        switch (this.model.dataRead[10]) {
            case 1: {
                LOGGER.log(Level.SEVERE, "Bootloader Erase Response Successful.");
                break;
            }
            case 2: {
                LOGGER.log(Level.SEVERE, "Bootloader Erase Response Successful.");
                LOGGER.log(Level.SEVERE, "Special Erase Request.");
                break;
            }
            case 254: {
                LOGGER.log(Level.SEVERE, "Bootloader Erase Responded Out-Of-Range.");
                throw new ValidationException("Bootloader Erase Responded Out-Of-Range.");
            }
            case 253: {
                LOGGER.log(Level.SEVERE, "Bootloader Erase Command NOT SUPPORTED.");
                throw new ValidationException("Bootloader Erase Command NOT SUPPORTED.");
            }
            default: {
                LOGGER.log(Level.SEVERE, "Bootloader Erase Command Unspecific failure.");
                throw new ValidationException("Bootloader Erase Unspecific failure.");
            }
        }
        if (this.model.errorStatus) {
            this.model.errorStatus = false;
            return -1;
        }
        return 0;
    }

    @Override
    protected void setPacketProcessorToUse() {
        this.commandSpecificPacketProcessor = new AVR_PacketProcessorEraseNoDataPayloadUART();
    }
}

