/*
 * Decompiled with CFR 0.152.
 */
package commands;

import com.microchip.mcu8.commandcore.ACommandBaseI2C;
import commands.ACommand;
import exceptionclasses.TransactionFailureException;
import i2cBootloaderController.CommandEraseDevice;
import i2cBootloaderController.CommandWriteDeviceEE;
import i2cBootloaderController.CommandWriteDeviceFlash;
import i2cBootloaderController.mcu8.CommandChecksum;
import i2cBootloaderController.mcu8.CommandReadVersionProtocolUSB;
import i2cBootloaderController.mcu8.CommandResetDevice;
import i2cBootloaderModel.BootloaderModel;
import i2cBootloaderModel.DeviceArchitecture;
import java.io.File;
import java.nio.charset.Charset;
import java.util.logging.Level;
import java.util.logging.Logger;
import observers.ABootloaderObserver;
import readFileController.HexFileIO;
import readFileController.IFileIO;
import readFileModel.MCU32MemoryModel;
import readFileModel.MemoryModel;
import unified.bootloader.model.UBootModel;

public class BootloadI2CDFUFED
extends ACommand<UBootModel> {
    private static final Logger LOGGER = Logger.getLogger(BootloadI2CDFUFED.class.getName());
    boolean propI2cSkipChecksum = false;
    private static final int retryAttempts = 1;
    private static final int genericTimeout = 1000;
    private static final int eraseTimeout = 20000;
    protected String fileName;
    protected ACommandBaseI2C readVersionCommand;
    protected ACommandBaseI2C eraseDeviceCommand;
    protected ACommandBaseI2C checksumCommand;
    protected ACommandBaseI2C resetCommand;
    protected ACommandBaseI2C writeCommand;
    protected ACommandBaseI2C writeCommandEE;
    protected ACommandBaseI2C writeCommandConfig;
    IFileIO fileReader = new HexFileIO();
    protected MemoryModel deviceMemoryModel = new MemoryModel(DeviceArchitecture.PIC18);
    protected BootloaderModel model = new BootloaderModel();

    public BootloadI2CDFUFED() {
        this.retryCount = 1;
        this.timeout = 1000;
        try {
            this.propI2cSkipChecksum = Boolean.getBoolean("i2c.skipChecksum");
        }
        catch (Exception ex) {
            LOGGER.log(Level.INFO, "Could not get configuration properties. Using defaults", ex);
        }
    }

    public void createCommands() {
        this.readVersionCommand = new CommandReadVersionProtocolUSB(((UBootModel)this.device).getI2CCommunicationInterface(), this.deviceMemoryModel);
        this.initializeCommands(this.readVersionCommand, 5, 1000);
    }

    public void createAllExceptReadVersion() {
        this.eraseDeviceCommand = new CommandEraseDevice(((UBootModel)this.device).getI2CCommunicationInterface(), this.deviceMemoryModel);
        this.checksumCommand = new CommandChecksum(((UBootModel)this.device).getI2CCommunicationInterface(), this.deviceMemoryModel);
        this.resetCommand = new CommandResetDevice(((UBootModel)this.device).getI2CCommunicationInterface(), this.deviceMemoryModel);
        this.writeCommand = new CommandWriteDeviceFlash(((UBootModel)this.device).getI2CCommunicationInterface(), this.deviceMemoryModel);
        this.writeCommandEE = new CommandWriteDeviceEE(((UBootModel)this.device).getI2CCommunicationInterface(), this.deviceMemoryModel);
        this.initializeCommands(this.eraseDeviceCommand, 1, 20000);
        this.initializeCommands(this.checksumCommand, 1, 1000);
        this.initializeCommands(this.resetCommand, 1, 1000);
        this.initializeCommands(this.writeCommand, 1, 1000);
        this.initializeCommands(this.writeCommandEE, 1, 1000);
    }

    public void setMemoryModelForDevice(MemoryModel deviceMemoryModel, int byteAlignedProgramMemorySize, int byteAlignedbootloaderOffset, int byteAlignedEraseRowSize, int setbyteAlignedeepromSize, int byteAlignedConfigMemoryOffset, int setbyteAlignedConfigSize, int byteAlignedeepromMemoryOffset, boolean skipErasedFlashLocationsFlag, int setbyteAlignedWriteBlockSize) {
        deviceMemoryModel.setbyteAlignedprogramMemorySize(byteAlignedProgramMemorySize);
        deviceMemoryModel.setbyteAlignedbootloaderOffset(byteAlignedbootloaderOffset);
        deviceMemoryModel.setbyteAlignedEraseRowSize(byteAlignedEraseRowSize);
        deviceMemoryModel.setbyteAlignedeepromSize(setbyteAlignedeepromSize);
        deviceMemoryModel.setbyteAlignedeepromMemoryOffset(byteAlignedeepromMemoryOffset);
        deviceMemoryModel.setskipErasedFlashLocationsFlag(skipErasedFlashLocationsFlag);
        deviceMemoryModel.setbyteAlignedWriteBlockSize(setbyteAlignedWriteBlockSize);
        deviceMemoryModel.setbyteAlignedconfigurationWordsOffset(byteAlignedConfigMemoryOffset);
        deviceMemoryModel.setbyteAlignedconfigurationWordsSize(setbyteAlignedConfigSize);
        deviceMemoryModel.createProgramMemoryMap();
        deviceMemoryModel.createEEPROMMap();
        deviceMemoryModel.createConfigurationWordsMap();
    }

    public void setMemoryModelForDevice(MCU32MemoryModel mcu32DeviceMemoryModel) {
        mcu32DeviceMemoryModel.createProgramMemoryMap();
    }

    public void initializeCommands(ACommandBaseI2C command, int retryCount, int timeout) {
        command.setTimeout(timeout);
        command.setRetryCount(retryCount);
        command.setBootloaderModel(this.model);
    }

    protected void setupDevice() {
        ((UBootModel)this.device).setConsoleText(this.timeStamp("Device: " + ((UBootModel)this.device).getDeviceName() + " Bootloading started"));
        LOGGER.log(Level.FINE, String.format("Device: " + ((UBootModel)this.device).getDeviceName() + " Bootloading started", new Object[0]));
        this.deviceMemoryModel = ((UBootModel)this.device).ubootPojo.getDeviceArchitecture().compareTo("PIC16") == 0 ? new MemoryModel(DeviceArchitecture.PIC16) : new MemoryModel(DeviceArchitecture.PIC18);
        this.setMemoryModelForDevice(this.deviceMemoryModel, Integer.parseInt(((UBootModel)this.device).ubootPojo.getProgramMemorySize().replace("0x", ""), 16), Integer.parseInt(((UBootModel)this.device).ubootPojo.getBootloaderOffset().replace("0x", ""), 16), Integer.parseInt(((UBootModel)this.device).ubootPojo.getByteAlignedEraseRowSize().replace("0x", ""), 16), Integer.parseInt(((UBootModel)this.device).ubootPojo.getSetbyteAlignedeepromSize().replace("0x", ""), 16), Integer.parseInt(((UBootModel)this.device).ubootPojo.getByteAlignedConfigMemoryOffset().replace("0x", ""), 16), Integer.parseInt(((UBootModel)this.device).ubootPojo.getSetbyteAlignedConfigSize().replace("0x", ""), 16), Integer.parseInt(((UBootModel)this.device).ubootPojo.getByteAlignedeepromMemoryOffset().replace("0x", ""), 16), true, Integer.parseInt(((UBootModel)this.device).ubootPojo.getWriteBlockSize().replace("0x", ""), 16));
        this.createCommands();
        this.model.addPropertyChangeListener(new ABootloaderObserver(){

            @Override
            public void handleEvent(BootloaderModel value, String whatChanged, String changed) {
                assert (whatChanged.equals("Version"));
                byte[] changedBytes = changed.getBytes(Charset.forName("ISO-8859-1"));
                String fs = "%s)        BLD_VER: %s          Device ID: 0x%02X           FL_ER: %d           FL_WR: %d           User ID: 0x%04X";
                String version = String.format(fs, ((UBootModel)BootloadI2CDFUFED.this.device).getDeviceName(), changedBytes[9], changedBytes[16] << 8 & 0xFFFF | changedBytes[15] & 0xFF, changedBytes[19] & 0xFF, changedBytes[20] & 0xFF, changedBytes[24] << 24 & 0xFFFFFFFF | changedBytes[23] << 16 & 0xFFFFFF | changedBytes[22] << 8 & 0xFFFF | changedBytes[21] & 0xFF);
                ((UBootModel)BootloadI2CDFUFED.this.device).setVersion(version);
                LOGGER.log(Level.FINE, String.format("%s: %s%n", whatChanged, version));
            }
        });
        this.model.addConsolePropertyChangeListener(new ABootloaderObserver(){

            @Override
            public void handleEvent(BootloaderModel value, String whatChanged, String changed) {
                ((UBootModel)BootloadI2CDFUFED.this.device).setProgress(changed);
            }
        });
    }

    @Override
    public void execute() throws TransactionFailureException {
        this.setupDevice();
        this.fileReader.setMemoryModel(this.deviceMemoryModel);
        this.fileName = ((UBootModel)this.device).ubootPojo.getFileName();
        if (this.fileName == null || this.fileName.isEmpty()) {
            LOGGER.log(Level.SEVERE, "Hex File is Invalid");
            throw new TransactionFailureException("Hex File is Invalid");
        }
        File fp = this.fileReader.fopen(this.fileName);
        this.fileReader.fread(fp);
        ((UBootModel)this.device).setConsoleText(this.timeStamp("Hex File (re)loaded..."));
        LOGGER.log(Level.FINE, this.timeStamp("Hex File (re)loaded ..."));
        try {
            boolean dividesOdd;
            String parsedWriteSize;
            Integer convertedEraseValue;
            String parsedEraseSize;
            ((UBootModel)this.device).setConsoleText(this.timeStamp("(20) Sec Timeout Check per CMD"));
            ((UBootModel)this.device).setConsoleText(this.timeStamp("Reading Version ..."));
            LOGGER.log(Level.FINE, this.timeStamp("Reading Version ..."));
            ((UBootModel)this.device).setConsoleText(this.timeStamp("Failure Hint: Check Communication with Device"));
            this.readVersionCommand.executeChain();
            ((UBootModel)this.device).setConsoleText(this.timeStamp("Bootloader Version Read Successful"));
            LOGGER.log(Level.FINE, this.timeStamp("Bootloader Version Read Successful"));
            if (this.deviceMemoryModel.deviceFamily.equals((Object)DeviceArchitecture.PIC16)) {
                parsedEraseSize = "0x" + Integer.toHexString(Integer.parseInt(((UBootModel)this.device).getVersion().subSequence(((UBootModel)this.device).getVersion().indexOf("FL_WR") + 7, ((UBootModel)this.device).getVersion().indexOf("User ID") - 11).toString()));
                convertedEraseValue = Integer.parseInt(((UBootModel)this.device).ubootPojo.getByteAlignedEraseRowSize().replace("0x", ""), 16);
                parsedWriteSize = "0x" + Integer.toHexString(Integer.parseInt(((UBootModel)this.device).getVersion().subSequence(((UBootModel)this.device).getVersion().indexOf("FL_WR") + 7, ((UBootModel)this.device).getVersion().indexOf("User ID") - 11).toString()));
                Integer convertedWriteValue = Integer.parseInt(((UBootModel)this.device).ubootPojo.getWriteBlockSize().replace("0x", ""), 16);
                ((UBootModel)this.device).ubootPojo.setWriteBlockSize(parsedWriteSize);
                if (convertedWriteValue == 64) {
                    convertedWriteValue = 32;
                }
                this.deviceMemoryModel.setbyteAlignedWriteBlockSize(convertedWriteValue);
                ((UBootModel)this.device).ubootPojo.setByteAlignedEraseRowSize(parsedEraseSize);
                convertedEraseValue = convertedEraseValue * 2;
                this.deviceMemoryModel.setbyteAlignedEraseRowSize(convertedEraseValue);
            } else {
                parsedEraseSize = "0x" + Integer.toHexString(Integer.parseInt(((UBootModel)this.device).getVersion().subSequence(((UBootModel)this.device).getVersion().indexOf("FL_ER") + 7, ((UBootModel)this.device).getVersion().indexOf("FL_WR") - 11).toString()));
                convertedEraseValue = Integer.parseInt(((UBootModel)this.device).ubootPojo.getByteAlignedEraseRowSize().replace("0x", ""), 16);
                parsedWriteSize = "0x" + Integer.toHexString(Integer.parseInt(((UBootModel)this.device).getVersion().subSequence(((UBootModel)this.device).getVersion().indexOf("FL_WR") + 7, ((UBootModel)this.device).getVersion().indexOf("User ID") - 11).toString()));
                Integer convertedWriteValue = Integer.parseInt(((UBootModel)this.device).ubootPojo.getWriteBlockSize().replace("0x", ""), 16);
                ((UBootModel)this.device).ubootPojo.setWriteBlockSize(parsedWriteSize);
                this.deviceMemoryModel.setbyteAlignedWriteBlockSize(convertedWriteValue);
                ((UBootModel)this.device).ubootPojo.setByteAlignedEraseRowSize(parsedEraseSize);
                this.deviceMemoryModel.setbyteAlignedEraseRowSize(convertedEraseValue);
            }
            boolean remainderExist = this.deviceMemoryModel.byteAlignedBootloaderOffset % this.deviceMemoryModel.byteAlignedWriteBlockSize == 1;
            Integer checkNumber = this.deviceMemoryModel.byteAlignedBootloaderOffset / this.deviceMemoryModel.byteAlignedWriteBlockSize;
            checkNumber = checkNumber / 2;
            boolean bl = dividesOdd = (checkNumber & 1) != 0;
            if (dividesOdd || remainderExist) {
                ((UBootModel)this.device).setConsoleText(this.timeStamp("WARNING: Application Offset exist between ROWS/PAGE boundaries."));
                ((UBootModel)this.device).setConsoleText(this.timeStamp("WARNING: Application Bootload may fail."));
                LOGGER.log(Level.SEVERE, this.timeStamp("WARNING: Application Offset exist between ROWS/PAGE boundaries."));
                LOGGER.log(Level.SEVERE, this.timeStamp("WARNING: Application Bootload may fail."));
            }
            this.createAllExceptReadVersion();
            ((UBootModel)this.device).setConsoleText(this.timeStamp("Erasing Device ..."));
            LOGGER.log(Level.FINE, this.timeStamp("Erasing Device ..."));
            ((UBootModel)this.device).setConsoleText(this.timeStamp("Failure Hint: Confirm Erase Range"));
            this.eraseDeviceCommand.executeChain();
            ((UBootModel)this.device).setConsoleText(this.timeStamp("Erase Successful"));
            LOGGER.log(Level.FINE, this.timeStamp("Erase Successful"));
            ((UBootModel)this.device).setConsoleText(this.timeStamp("Programming Flash ..."));
            LOGGER.log(Level.FINE, this.timeStamp("Programming Flash ..."));
            ((UBootModel)this.device).setConsoleText(this.timeStamp("Failure Hint: Confirm Hex Offset"));
            this.writeCommand.executeChain();
            ((UBootModel)this.device).setConsoleText(this.timeStamp("Flashed Programmed"));
            LOGGER.log(Level.FINE, this.timeStamp("Flashed Programmed"));
            if (((UBootModel)this.device).ubootPojo.getProgramEEData().compareTo("Enabled") == 0) {
                ((UBootModel)this.device).setConsoleText(this.timeStamp("Programming EEData ..."));
                LOGGER.log(Level.FINE, this.timeStamp("Programming EEData ..."));
                this.writeCommandEE.executeChain();
                ((UBootModel)this.device).setConsoleText(this.timeStamp("EEData Programmed"));
                LOGGER.log(Level.FINE, this.timeStamp("EEData Programmed"));
            }
            if (((UBootModel)this.device).ubootPojo.getProgramConfigurationWords().compareTo("Enabled") == 0) {
                ((UBootModel)this.device).setConsoleText(this.timeStamp("Programming Configuration Words ..."));
                LOGGER.log(Level.FINE, this.timeStamp("Programming Configuration Words ..."));
                this.writeCommandConfig.executeChain();
                ((UBootModel)this.device).setConsoleText(this.timeStamp("Configuration Words Programmed"));
                LOGGER.log(Level.FINE, this.timeStamp("Configuration Words Programmed"));
            }
            if (!this.propI2cSkipChecksum) {
                ((UBootModel)this.device).setConsoleText(this.timeStamp("Retrieving Checksum ..."));
                LOGGER.log(Level.FINE, this.timeStamp("Retrieving Checksum ..."));
                ((UBootModel)this.device).setConsoleText(this.timeStamp("Failure Hint: Check Build Properties"));
                this.checksumCommand.executeChain();
                ((UBootModel)this.device).setConsoleText(this.timeStamp("Checksum Matched"));
                LOGGER.log(Level.FINE, this.timeStamp("Checksum Matched"));
            }
            ((UBootModel)this.device).setConsoleText(this.timeStamp("Resetting Device"));
            LOGGER.log(Level.FINE, this.timeStamp("Resetting Device"));
            this.resetCommand.executeChain();
            ((UBootModel)this.device).setConsoleText(this.timeStamp("Device Reset"));
            LOGGER.log(Level.FINE, this.timeStamp("Device Reset"));
            ((UBootModel)this.device).setConsoleText(this.timeStamp("FULL Bootloader SUCCESSFUL"));
            ((UBootModel)this.device).setConsoleText(this.timeStamp("Device: " + ((UBootModel)this.device).getDeviceName() + " Bootloading Successful"));
            LOGGER.log(Level.FINE, this.timeStamp("Device: " + ((UBootModel)this.device).getDeviceName() + " Bootloading Successful"));
        }
        catch (TransactionFailureException ex) {
            ((UBootModel)this.device).setConsoleText(this.timeStamp("Device Failed to respond to command..."));
            LOGGER.log(Level.SEVERE, "Chain Exception Thrown: ", ex);
        }
    }

    @Override
    public void setDataModel(UBootModel model) {
        this.device = model;
    }

    @Override
    public UBootModel getDataModel() {
        return (UBootModel)this.device;
    }
}

