/*
 * Decompiled with CFR 0.152.
 */
package console16bit;

import console16bit.Console16bit;
import console16bit.Console16bitController;
import console16bit.ConsoleFXMLController16bit;
import java.io.IOException;
import java.net.URL;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.stage.Modality;
import javafx.stage.Stage;

public class Console16bitImpl
implements Console16bit {
    static final Level DEFAULT_LEVEL = Level.INFO;
    private Stage dialogStage;
    private final Console16bitController form;
    private Supplier<LocalDateTime> dateSupplier;
    private final boolean useFx;

    public Console16bitImpl() {
        this.form = new ConsoleFXMLController16bit();
        this.dateSupplier = LocalDateTime::now;
        this.dialogStage = new Stage();
        try {
            this.setStage("ConsoleFXML16bit.fxml");
        }
        catch (IOException ex) {
            Logger.getLogger(Console16bitImpl.class.getName()).log(Level.SEVERE, "Failed to start console.", ex);
        }
        this.useFx = true;
    }

    public Console16bitImpl(Console16bitController controller, Supplier<LocalDateTime> dateSupplier) {
        this.form = controller;
        this.dateSupplier = dateSupplier;
        this.useFx = false;
    }

    private void setStage(String resourceFile) throws IOException {
        Parent root = this.getFXMLResourceFile(resourceFile);
        this.dialogStage.setScene(new Scene(root));
        this.dialogStage.setTitle("Console");
        this.dialogStage.initModality(Modality.WINDOW_MODAL);
    }

    private String timeStamp() {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("HH:mm:ss.SSS");
        return this.dateSupplier.get().format(formatter);
    }

    private void run(Runnable runnable) {
        if (this.useFx) {
            this.runOnFX(runnable);
        } else {
            runnable.run();
        }
    }

    private void runOnFX(Runnable runnable) {
        if (Platform.isFxApplicationThread()) {
            runnable.run();
        } else {
            Platform.runLater((Runnable)runnable);
        }
    }

    private boolean logWithThisLevel(Level msgLogLevel) {
        return msgLogLevel.intValue() >= this.form.getLogLevel().intValue();
    }

    @Override
    public void displayConsole() {
        this.dialogStage.show();
    }

    private Parent getFXMLResourceFile(String resourceFile) throws IOException {
        URL location = this.getClass().getResource(resourceFile);
        FXMLLoader loader = new FXMLLoader(location);
        loader.setController((Object)this.form);
        Object result = loader.load();
        return (Parent)result;
    }

    @Override
    public final void addConsoleText(String consoleText) {
        this.addConsoleText(DEFAULT_LEVEL, consoleText);
    }

    @Override
    public void addConsoleText(ArrayList<String> consoleText) {
        this.addConsoleText(DEFAULT_LEVEL, consoleText);
    }

    @Override
    public void addConsoleText(Level level, String consoleText) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(consoleText);
        this.addConsoleText(level, list);
    }

    @Override
    public void addConsoleText(Level level, ArrayList<String> consoleText) {
        if (this.logWithThisLevel(level)) {
            StringBuilder toPrint = new StringBuilder();
            toPrint.append("[").append(level.toString()).append("] ").append(this.timeStamp()).append(" >\n");
            for (String lineText : consoleText) {
                toPrint.append("   ").append(lineText).append("\n");
            }
            this.run(() -> this.form.setConsoleViewText(toPrint.toString()));
        }
    }
}

