/*
 * Decompiled with CFR 0.152.
 */
package unified.bootloader16bit;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;

public class ByteChannelFastImpl
implements ByteChannel {
    private final ReadableByteChannel readableByteChannel;
    private InputStream inputStream;
    private final WritableByteChannel writableByteChannel;

    public ByteChannelFastImpl(InputStream inputStream, OutputStream outputStream) {
        this.readableByteChannel = Channels.newChannel(inputStream);
        this.writableByteChannel = Channels.newChannel(outputStream);
        this.inputStream = inputStream;
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        if (this.inputStream.available() > 0) {
            return this.readableByteChannel.read(dst);
        }
        return 0;
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        return this.writableByteChannel.write(src);
    }

    @Override
    public boolean isOpen() {
        return this.readableByteChannel.isOpen() && this.writableByteChannel.isOpen();
    }

    @Override
    public void close() throws IOException {
        this.readableByteChannel.close();
        this.writableByteChannel.close();
    }
}

