/*
 * Decompiled with CFR 0.152.
 */
package unified.bootloader16bit;

import console16bit.Console16bit;
import java.util.function.Consumer;
import unified.bootloader16bit.Protocol;
import unified.bootloader16bit.ProtocolException;
import unified.bootloader16bit.ProtocolMock;
import unified.bootloader16bit.ProtocolNull;
import unified.bootloader16bit.phy.can.ProtocolCan;
import unified.bootloader16bit.phy.i2c.ProtocolI2C;
import unified.bootloader16bit.phy.lin.ProtocolLin;
import unified.bootloader16bit.phy.uart.ProtocolUart;

public class ProtocolFactory {
    private ProtocolFactory() {
    }

    static Protocol getProtocol(String protocol, Console16bit console) {
        return ProtocolFactory.getProtocol(protocol, console, exception -> {});
    }

    static Protocol getProtocol(String protocol, Console16bit console, Consumer<ProtocolException> handler) {
        if (protocol == null) {
            return new ProtocolNull();
        }
        if (console == null) {
            return new ProtocolNull();
        }
        if (protocol.equals("UART")) {
            return new ProtocolUart(console);
        }
        if (protocol.equals("CAN")) {
            return new ProtocolCan(console, handler);
        }
        if (protocol.equals("I2C")) {
            return new ProtocolI2C(console);
        }
        if (protocol.equals("MOCK")) {
            return new ProtocolMock();
        }
        if (protocol.equals("LIN")) {
            return new ProtocolLin(console);
        }
        return new ProtocolNull();
    }
}

