/*
 * Decompiled with CFR 0.152.
 */
package unified.bootloader16bit;

import unified.bootloader16bit.DetailedException;

public class TimeoutException
extends DetailedException {
    private static final String SUMMARY = "Communications timed out.";
    private final byte[] partialResponse;

    public TimeoutException() {
        this(new byte[0]);
    }

    public TimeoutException(byte[] partialResponse) {
        super(SUMMARY, TimeoutException.createDetails(partialResponse));
        this.partialResponse = partialResponse == null ? new byte[]{} : partialResponse;
    }

    private static boolean isResponseEmpty(byte[] partialResponse) {
        return partialResponse == null || partialResponse.length == 0;
    }

    private static String createDetails(byte[] partialResponse) {
        if (TimeoutException.isResponseEmpty(partialResponse)) {
            return "Communications timed out during a read.  No data was received.";
        }
        StringBuilder sb = new StringBuilder();
        for (byte b : partialResponse) {
            sb.append(String.format("0x%x ", b));
        }
        return "Communications timed out during a read.  The following data was received before the timeout: \n" + sb.toString() + " <END>\n";
    }

    public byte[] getPartialResponse() {
        return this.partialResponse;
    }
}

