/*
 * Decompiled with CFR 0.152.
 */
package unified.bootloader16bit.phy.can;

import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import unified.bootloader16bit.phy.AModel;
import unified.bootloader16bit.phy.can.MessageFormat;

class Model
extends AModel {
    private Integer nominalBitRate;
    private String hostToDeviceId;
    private String deviceToHostId;
    private Integer dataBitRate;
    private boolean isDataRateEnabled;
    private boolean isCanFdEnabled;
    private Integer txDL;
    private MessageFormat messageFormat;
    private static final Integer CAN_CLASSIC_TX_DL = 8;

    public Model() {
        this(Collections::emptyList);
    }

    public Model(Supplier<List<String>> portSupplier) {
        this.portSupplier = portSupplier;
        this.nominalBitRate = 125000;
        this.hostToDeviceId = "0xA1";
        this.deviceToHostId = "0xA2";
        this.port = "";
        this.dataBitRate = 2000000;
        this.isDataRateEnabled = false;
        this.txDL = 8;
        this.messageFormat = MessageFormat.STANDARD;
    }

    public Integer getNominalBitRate() {
        return this.nominalBitRate;
    }

    public void setNominalBitRate(Integer bitRate) {
        this.nominalBitRate = bitRate;
    }

    public void setHostToDeviceId(String id) {
        this.hostToDeviceId = id;
    }

    public String getHostToDeviceId() {
        return this.hostToDeviceId;
    }

    public void setDeviceToHostId(String id) {
        this.deviceToHostId = id;
    }

    public String getDeviceToHostId() {
        return this.deviceToHostId;
    }

    public int getDataBitRate() {
        return this.dataBitRate;
    }

    public void setDataBitRate(Integer bitRate) {
        this.dataBitRate = bitRate;
    }

    public boolean isDataBitRateEnabled() {
        return this.isDataRateEnabled;
    }

    public void setDataBitRateEnabled(boolean enabled) {
        this.isDataRateEnabled = enabled;
    }

    public boolean isCanFdEnabled() {
        return this.isCanFdEnabled;
    }

    public void setCanFdEnabled(boolean enabled) {
        this.isCanFdEnabled = enabled;
    }

    public Integer getTxDL() {
        if (this.isCanFdEnabled) {
            return this.txDL;
        }
        return CAN_CLASSIC_TX_DL;
    }

    public void setTxDL(Integer txDL) {
        this.txDL = txDL;
    }

    public Integer getFDTxDL() {
        return this.txDL;
    }

    public MessageFormat getMessageFormat() {
        return this.messageFormat;
    }

    public void setMessageFormat(MessageFormat messageFormat) {
        this.messageFormat = messageFormat;
    }
}

