/*
 * Decompiled with CFR 0.152.
 */
package unified.bootloader16bit.phy.uart;

import console16bit.Console16bit;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import purejavacomm.CommPortIdentifier;
import purejavacomm.PortInUseException;
import purejavacomm.SerialPort;
import purejavacomm.UnsupportedCommOperationException;
import unified.bootloader16bit.ProtocolException;
import unified.bootloader16bit.ProtocolInUseException;
import unified.bootloader16bit.phy.uart.SerialPortWrapper;

public class SerialPortWrapperImpl
implements SerialPortWrapper {
    boolean portIsOpen = false;
    private SerialPort port;
    Console16bit console;

    @Override
    public SerialPortWrapper openSerialPortWrapper(String portName, Console16bit console) throws ProtocolException, ProtocolInUseException {
        CommPortIdentifier portId = this.getMapping().get(portName);
        this.console = console;
        console.addConsoleText(Level.FINE, "Opening COM Port " + portName + ", Settings: XXXXXX, 8N1");
        if (portId == null) {
            throw new ProtocolException("The specified serial port does not exist.");
        }
        console.addConsoleText(Level.FINE, "Opening COM Port " + portName);
        try {
            this.port = (SerialPort)portId.open("Test", 1000);
        }
        catch (PortInUseException e) {
            console.addConsoleText(Level.SEVERE, "COM Port " + portName + " is in use");
            throw new ProtocolInUseException("Serial Port in use");
        }
        return this;
    }

    @Override
    public void close() {
        if (this.port != null) {
            this.port.close();
        }
    }

    @Override
    public void setDTR(boolean bln) {
        this.port.setDTR(bln);
    }

    @Override
    public void setRTS(boolean bln) {
        this.port.setDTR(bln);
    }

    @Override
    public boolean isRTS() {
        if (this.port != null) {
            return this.port.isRTS();
        }
        return false;
    }

    @Override
    public boolean isDTR() {
        if (this.port != null) {
            return this.port.isDTR();
        }
        return false;
    }

    @Override
    public int getBaudRate() {
        if (this.port != null) {
            return this.port.getBaudRate();
        }
        return 0;
    }

    @Override
    public void setSerialPortParams(int i, int i1, int i2, int i3) throws ProtocolException {
        try {
            this.port.setSerialPortParams(i, i1, i2, i3);
        }
        catch (UnsupportedCommOperationException e) {
            throw new ProtocolException("The communications adapter was not able to support an operation requested of it.  Please check the settings to ensure they are compatible with the selected adapter.");
        }
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.port.getInputStream();
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.port.getOutputStream();
    }

    @Override
    public List<String> getPorts() {
        return new ArrayList<String>(this.getMapping().keySet());
    }

    private Map<String, CommPortIdentifier> getMapping() {
        HashMap<String, CommPortIdentifier> mapping = new HashMap<String, CommPortIdentifier>();
        Enumeration<CommPortIdentifier> portIdentifiers = CommPortIdentifier.getPortIdentifiers();
        while (portIdentifiers.hasMoreElements()) {
            CommPortIdentifier p = portIdentifiers.nextElement();
            String name = p.getName();
            mapping.put(name, p);
        }
        return mapping;
    }
}

