/*
 * Decompiled with CFR 0.152.
 */
package unified.bootloaderAVR;

import I2CSettingAVRMCU8.I2CSettingsAVRMCU8;
import com.microchip.scf.CommunicationsInterface;
import com.microchip.scf.softwarelibraryinterfaces.i2c.I2CSoftwareLibraryCommunicationsInterface;
import commands.BootloadI2CDFUEDAVRMCU8;
import commands.BootloadSerialAVRMCU8;
import commands.ICommand;
import consoleAVRMCU8.ConsoleAVRMCU8;
import i2cReadWriteStopXferFunctions.MCPUSBI2CBridgeAdapter;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import java.util.logging.StreamHandler;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Alert;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.TextField;
import javafx.stage.FileChooser;
import observers.ALoraObserver;
import portSettingsAVRMCU8.PortAVRMCU8Settings;
import toplevel.JavaFXTextFieldChangeListener;
import uartjsscadapter.JSSCSerialPortAdapter;
import unified.MVController.MVController;
import unified.bootloader.model.IDeviceModel;
import unified.bootloader.modelMccAVR.UBootAVRMCU8Model;
import unified.bootloaderAVR.UBootAVR;
import usbhid4javaserviceprovider.Hid4JavaUSBAdapter;

public class UBootAVRFXMLController
implements Initializable {
    UBootAVR application;
    JSSCSerialPortAdapter jsscDriverInterface = new JSSCSerialPortAdapter();
    Hid4JavaUSBAdapter usbDriverInterface = new Hid4JavaUSBAdapter();
    CommunicationsInterface commsInterface;
    I2CSoftwareLibraryCommunicationsInterface i2cInterface = new MCPUSBI2CBridgeAdapter();
    private static final Logger LOGGER = Logger.getLogger(UBootAVRFXMLController.class.getName());
    @FXML
    private ComboBox<String> deviceList;
    @FXML
    private ComboBox<String> comboProtocol;
    private final String stringUART = "UART";
    private final String stringI2C = "I2C";
    @FXML
    private Label labelConfigStatus;
    @FXML
    private ProgressBar progress;
    @FXML
    private Label labelStatusResult;
    FileChooser fileOpenDialog = new FileChooser();
    Map<TextField, JavaFXTextFieldChangeListener<UBootAVRMCU8Model>> changeListener = new HashMap<TextField, JavaFXTextFieldChangeListener<UBootAVRMCU8Model>>();
    ConsoleAVRMCU8 console = null;
    int progressMax = 100;
    int progressCurrent = 1;
    private final String stringNotConfigured = "Not Configured";
    private final String stringReady = "Ready";
    private final String stringConnected = "Device Connected Successfully";
    private final String stringNoConnection = "No Current Device Connection";
    private static final int SERIAL_TIMEOUT = 20000;
    private static final int USB_TIMEOUT = 50000;

    public UBootAVRFXMLController(UBootAVR application) {
        this.application = application;
    }

    public void initialize(URL url, ResourceBundle rb) {
        LOGGER.addHandler(new StreamHandler(System.out, new SimpleFormatter()));
        this.jsscDriverInterface.setTimeOut(20000);
        this.usbDriverInterface.setTimeOut(50000);
        this.application.device.ubootPojoAVRMCU8.setProtocolType("UART");
        this.labelStatusResult.setText("Communication Method: UART");
        this.labelConfigStatus.setText("Not Configured");
        this.comboProtocol.getItems().add((Object)"UART");
        this.comboProtocol.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                if (newValue != null) {
                    UBootAVRFXMLController.this.labelStatusResult.setText("No Current Device Connection");
                    UBootAVRFXMLController.this.labelConfigStatus.setText("Not Configured");
                    UBootAVRFXMLController.this.application.device.ubootPojoAVRMCU8.setProtocolType(newValue);
                    LOGGER.log(Level.FINE, String.format(UBootAVRFXMLController.this.application.device.ubootPojoAVRMCU8.getProtocolType().get() + " Protocol Selected", new Object[0]));
                }
            }
        });
        this.comboProtocol.getSelectionModel().select((Object)"UART");
        this.progress.setProgress(0.0);
        this.application.getModel().ubootPojoAVRMCU8.getConfigurationChangedState().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (UBootAVRFXMLController.this.application.getModel().ubootPojoAVRMCU8.getConfigurationChangedState().getValue().booleanValue()) {
                    UBootAVRFXMLController.this.configureSettings();
                }
            }
        });
        this.application.getModel().ubootPojoAVRMCU8.getConsoleState().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (UBootAVRFXMLController.this.application.getModel().ubootPojoAVRMCU8.getConsoleState().getValue().booleanValue()) {
                    UBootAVRFXMLController.this.showConsole();
                }
            }
        });
        this.console = ConsoleAVRMCU8.getConsole(this.application);
        this.application.device.addPropertyChangeListener(new ALoraObserver<UBootAVRMCU8Model>(){

            @Override
            public void handleEvent(UBootAVRMCU8Model value, final String whatChanged) {
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (whatChanged.compareTo("Property") == 0 && !UBootAVRFXMLController.this.labelConfigStatus.getText().equals("Not Configured")) {
                            UBootAVRFXMLController.this.labelStatusResult.setText("Device Connected Successfully");
                        }
                    }
                });
            }
        });
        this.application.device.addPropertyChangeListener(new ALoraObserver<UBootAVRMCU8Model>(){

            @Override
            public void handleEvent(UBootAVRMCU8Model value, final String whatChanged) {
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (whatChanged.compareTo("WriteBlockSize") == 0) {
                            UBootAVRFXMLController.this.progressMax = (Integer.parseInt(UBootAVRFXMLController.this.application.getModel().ubootPojoAVRMCU8.getProgramMemorySize().replace("0x", ""), 16) - Integer.parseInt(UBootAVRFXMLController.this.application.getModel().ubootPojoAVRMCU8.getBootloaderOffset().replace("0x", ""), 16)) / Integer.parseInt(UBootAVRFXMLController.this.application.getModel().ubootPojoAVRMCU8.getWriteBlockSize().replace("0x", ""), 16);
                        }
                    }
                });
            }
        });
        this.application.device.addPropertyChangeListener(new ALoraObserver<UBootAVRMCU8Model>(){

            @Override
            public void handleEvent(UBootAVRMCU8Model value, final String whatChanged) {
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (whatChanged.compareTo("WriteBlockSize") == 0) {
                            UBootAVRFXMLController.this.progressMax = (Integer.parseInt(UBootAVRFXMLController.this.application.getModel().ubootPojoAVRMCU8.getProgramMemorySize().replace("0x", ""), 16) - Integer.parseInt(UBootAVRFXMLController.this.application.getModel().ubootPojoAVRMCU8.getBootloaderOffset().replace("0x", ""), 16)) / Integer.parseInt(UBootAVRFXMLController.this.application.getModel().ubootPojoAVRMCU8.getWriteBlockSize().replace("0x", ""), 16);
                        }
                    }
                });
            }
        });
        this.application.device.addConsolePropertyChangeListener(new ALoraObserver<UBootAVRMCU8Model>(){

            @Override
            public void handleEvent(UBootAVRMCU8Model value, final String whatChanged) {
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (whatChanged.compareTo("Progress") == 0) {
                            UBootAVRFXMLController.this.progress.setProgress((double)UBootAVRFXMLController.this.progressCurrent / (double)UBootAVRFXMLController.this.progressMax);
                            ++UBootAVRFXMLController.this.progressCurrent;
                        }
                    }
                });
            }
        });
        this.application.getModel().i2cPojoAVRMCU8.getConfigured().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                UBootAVRFXMLController.this.configureLabelUpdate();
            }
        });
        this.application.getModel().dfuPojoAVRMCU8.getConfigured().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                UBootAVRFXMLController.this.configureLabelUpdate();
            }
        });
        this.deviceList.getItems().add((Object)"Generated Protocol");
        this.deviceList.getSelectionModel().clearSelection();
        this.deviceList.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                if (newValue != null) {
                    UBootAVRFXMLController.this.application.device.ubootPojoAVRMCU8.setDeviceArchitecture(newValue);
                    LOGGER.log(Level.FINE, String.format(UBootAVRFXMLController.this.application.device.ubootPojoAVRMCU8.getDeviceArchitecture(), new Object[0]));
                    UBootAVRFXMLController.this.architectureDefaults();
                }
            }
        });
        this.deviceList.getSelectionModel().selectFirst();
    }

    private void architectureDefaults() {
    }

    private void configureSettings() {
        String currentProtocol = (String)this.comboProtocol.getValue();
        this.labelConfigStatus.setText("Configuring Communication Method.");
        if (currentProtocol.contains("UART")) {
            this.application.device.dfuPojoAVRMCU8.setConfigured(false);
            this.configureComSettings();
        } else if (currentProtocol.contains("I2C")) {
            this.application.device.i2cPojoAVRMCU8.setConfigured(false);
            this.configureI2CSettings();
        }
        this.application.getModel().ubootPojoAVRMCU8.setConfigurationChangedState(false);
    }

    private void configureComSettings() {
        this.commsInterface = this.jsscDriverInterface;
        PortAVRMCU8Settings setting = new PortAVRMCU8Settings(this.application);
        try {
            this.application.device.dfuPojoAVRMCU8.getComList().clear();
            String[] returnedListAvailable = this.commsInterface.getAttachedDevices();
            this.application.device.dfuPojoAVRMCU8.getComList().addAll(Arrays.asList(returnedListAvailable));
            setting.start();
        }
        catch (Exception ex) {
            LOGGER.log(Level.SEVERE, "Failed to configure COM Settings. " + ex.toString(), ex);
        }
    }

    private void configureI2CSettings() {
        this.commsInterface = this.usbDriverInterface;
        this.i2cInterface.aetLowerLevelCommunicationsInterface(this.commsInterface);
        I2CSettingsAVRMCU8 setting = new I2CSettingsAVRMCU8(this.application);
        try {
            this.application.device.i2cPojoAVRMCU8.getDeviceList().clear();
            String[] returnedListAvailable = this.commsInterface.getAttachedDevices();
            this.application.device.i2cPojoAVRMCU8.getDeviceList().addAll(Arrays.asList(returnedListAvailable));
            setting.start();
        }
        catch (Exception ex) {
            LOGGER.log(Level.SEVERE, "Failed to configure I2C Settings. " + ex.toString(), ex);
        }
    }

    void configureLabelUpdate() {
        String protocol = this.application.device.ubootPojoAVRMCU8.getProtocolType().get();
        if (protocol.contains("UART")) {
            try {
                this.commsInterface = this.jsscDriverInterface;
                this.commsInterface.setDeviceName(this.application.device.dfuPojoAVRMCU8.getComPort());
                this.commsInterface.connect();
                this.jsscDriverInterface.setDeviceName(this.application.device.dfuPojoAVRMCU8.getComPort());
                this.jsscDriverInterface.baudRate = Integer.parseInt(this.application.device.dfuPojoAVRMCU8.getBaudRate());
                this.jsscDriverInterface.dataBits = Integer.parseInt(this.application.device.dfuPojoAVRMCU8.getDataBits());
                this.jsscDriverInterface.stopBits = Integer.parseInt(this.application.device.dfuPojoAVRMCU8.getStopBits());
                String readParity = this.application.device.dfuPojoAVRMCU8.getParity();
                if (readParity.contains("Enabled")) {
                    this.jsscDriverInterface.setParity(true);
                } else {
                    this.jsscDriverInterface.setParity(false);
                }
                this.commsInterface.disconnect();
            }
            catch (IOException ex) {
                this.labelConfigStatus.setText("Failed to be able to connect to Serial Interface.");
                LOGGER.log(Level.SEVERE, "Failed to be able to connect to Serial Interface." + ex.toString(), ex);
            }
            StringBuilder statusLabel = new StringBuilder();
            statusLabel.append(this.jsscDriverInterface.getDeviceName());
            statusLabel.append(" @ ");
            statusLabel.append(this.jsscDriverInterface.getBaudRate());
            statusLabel.append(" DB: ");
            statusLabel.append(this.jsscDriverInterface.getStartBits());
            statusLabel.append(" SB: ");
            statusLabel.append(this.jsscDriverInterface.getStopBits());
            statusLabel.append(" Parity: ");
            statusLabel.append(this.jsscDriverInterface.getParity());
            this.labelConfigStatus.setText(statusLabel.toString());
        } else if (protocol.contains("I2C")) {
            StringBuilder statusLabel = new StringBuilder();
            statusLabel.append("Device w PID: ");
            statusLabel.append(this.application.device.i2cPojoAVRMCU8.getDeviceSelected());
            statusLabel.append(" BitRate: ");
            statusLabel.append(this.application.device.i2cPojoAVRMCU8.getDeviceBitRate());
            statusLabel.append("(Kbits/s) @ Address: ");
            statusLabel.append(this.application.device.i2cPojoAVRMCU8.getDeviceAddress());
            this.labelConfigStatus.setText(statusLabel.toString());
        } else {
            this.labelStatusResult.setText("Error Has Occured. Configuration Bad");
        }
    }

    @FXML
    void programDevice(ActionEvent event) {
        String protocol = this.application.device.ubootPojoAVRMCU8.getProtocolType().get();
        String name = this.application.device.ubootPojoAVRMCU8.getFileName();
        if (name == null) {
            Alert alert = new Alert(Alert.AlertType.ERROR);
            alert.setTitle("Error Dialog");
            alert.setHeaderText("Hex File Selection");
            alert.setContentText("HEX file not selected. Could not start programming the device.\nPlease choose a .hex file from the File Menu Dialog.");
            alert.showAndWait();
            return;
        }
        this.labelStatusResult.setText("Attempting Bootloader Command Chain Example.");
        if (protocol.contains("UART")) {
            this.programSerial();
        } else if (protocol.contains("I2C")) {
            this.programI2C();
        }
    }

    public void programSerial() {
        this.ConnectSerial();
        this.progressCurrent = 1;
        ArrayList<ICommand> commands = new ArrayList<ICommand>();
        BootloadSerialAVRMCU8 bootload = new BootloadSerialAVRMCU8();
        bootload.setDataModel(this.application.getModel());
        commands.add(bootload);
        this.application.mvcController.execute(commands);
    }

    public void programI2C() {
        this.ConnectI2C();
        this.progressCurrent = 1;
        ArrayList<ICommand> commands = new ArrayList<ICommand>();
        BootloadI2CDFUEDAVRMCU8 bootload = new BootloadI2CDFUEDAVRMCU8();
        bootload.setDataModel(this.application.getModel());
        commands.add(bootload);
        this.application.mvcController.execute(commands);
    }

    public void ConnectSerial() {
        this.commsInterface = this.jsscDriverInterface;
        LOGGER.log(Level.FINE, String.format("Trying to Connect: " + this.application.device.dfuPojoAVRMCU8.getComPort(), new Object[0]));
        try {
            this.commsInterface.connect();
            this.application.startupConnectedDeviceMap.put(this.application.device.dfuPojoAVRMCU8.getComPort(), this.jsscDriverInterface);
            this.application.injectController(new MVController());
            this.application.setDeviceName(this.application.device.dfuPojoAVRMCU8.getComPort());
            this.application.mvcController.afterFailure(new Failure(this.application.getModel()));
            this.application.mvcController.afterSuccess(new Success(this.application.getModel()));
            this.application.injectModelCommunicationInterface(this.jsscDriverInterface);
        }
        catch (IOException ex) {
            this.labelStatusResult.setText("Failed to be able to connect to Serial Interface.");
            LOGGER.log(Level.SEVERE, "Device Creation Failed. " + ex.toString(), ex);
        }
    }

    public void ConnectI2C() {
        try {
            this.commsInterface.setDeviceName(this.application.device.i2cPojoAVRMCU8.getDeviceSelected());
            boolean connectResult = this.commsInterface.connect();
            LOGGER.fine(String.format("connect result: %s", connectResult));
            this.usbDriverInterface.setDeviceName(this.application.device.i2cPojoAVRMCU8.getDeviceSelected());
            Integer integerI2CAddress = Integer.parseInt(this.application.device.i2cPojoAVRMCU8.getDeviceAddress().replace("0x", ""), 16);
            String stringI2CAddressValue = Integer.toString(integerI2CAddress);
            byte readI2CAddressValue = Byte.valueOf(stringI2CAddressValue);
            this.i2cInterface.setI2CAddress(readI2CAddressValue);
            this.i2cInterface.setBitrate(Integer.parseInt(this.application.device.i2cPojoAVRMCU8.getDeviceBitRate()));
        }
        catch (IOException ex) {
            LOGGER.log(Level.SEVERE, "Failed to be able to connect to I2C Interface.", ex);
        }
        this.commsInterface = this.usbDriverInterface;
        this.i2cInterface.aetLowerLevelCommunicationsInterface(this.commsInterface);
        LOGGER.log(Level.FINE, String.format("Trying to Connect: " + this.application.device.i2cPojoAVRMCU8.getDeviceSelected(), new Object[0]));
        this.application.startupConnectedDeviceMap.put(this.application.device.i2cPojoAVRMCU8.getDeviceSelected(), this.usbDriverInterface);
        this.application.injectController(new MVController());
        this.application.setDeviceName(this.application.device.i2cPojoAVRMCU8.getDeviceSelected());
        this.application.mvcController.afterFailure(new Failure(this.application.getModel()));
        this.application.mvcController.afterSuccess(new Success(this.application.getModel()));
        this.application.injectI2CInterface(this.i2cInterface);
    }

    void handleDisconnect(IDeviceModel dev) {
        this.labelStatusResult.setText("Attempt Completed. Result in Console.");
        LOGGER.log(Level.FINE, String.format("Trying to Disconnect: " + this.application.device.dfuPojoAVRMCU8.getComPort(), new Object[0]));
        try {
            this.commsInterface.disconnect();
        }
        catch (IOException ex) {
            LOGGER.log(Level.SEVERE, "Device Destruction Failed" + ex.toString(), ex);
        }
    }

    private void showConsole() {
        try {
            this.console.init();
        }
        catch (Exception ex) {
            LOGGER.log(Level.SEVERE, "Show Console Failed. " + ex.toString(), ex);
        }
        this.application.getModel().ubootPojoAVRMCU8.setConsoleState(false);
    }

    class Success
    implements EventHandler {
        IDeviceModel dev = null;

        public Success(IDeviceModel dev) {
            this.dev = dev;
        }

        public void handle(Event event) {
            UBootAVRFXMLController.this.progress.setProgress(0.0);
            UBootAVRFXMLController.this.handleDisconnect(this.dev);
            LOGGER.log(Level.FINE, "Disconnected after Programming Action was Completed.");
        }
    }

    class Failure
    implements EventHandler {
        IDeviceModel dev = null;

        public Failure(IDeviceModel dev) {
            this.dev = dev;
        }

        public void handle(Event event) {
            UBootAVRFXMLController.this.progress.setProgress(0.0);
            UBootAVRFXMLController.this.handleDisconnect(this.dev);
            UBootAVRFXMLController.this.labelStatusResult.setText("Disconnected after Programming Failed.");
            LOGGER.log(Level.SEVERE, "Disconnected after Programming Failed.");
        }
    }
}

