/*
 * Decompiled with CFR 0.152.
 */
package commands;

import com.microchip.mcu8.commandcore.ACommandBase;
import commands.ACommand;
import exceptionclasses.TransactionFailureException;
import i2cBootloaderController.CommandChecksumUART_AVR;
import i2cBootloaderController.CommandEraseDeviceUART_AVR;
import i2cBootloaderController.CommandResetDeviceUART_AVR;
import i2cBootloaderController.CommandWriteDeviceFlashUART_AVR;
import i2cBootloaderController.avr.CommandReadVersionUART_AVR;
import i2cBootloaderModel.BootloaderModel;
import i2cBootloaderModel.DeviceArchitecture;
import java.io.File;
import java.nio.charset.Charset;
import java.util.logging.Level;
import java.util.logging.Logger;
import observers.ABootloaderObserver;
import readFileController.HexFileIO;
import readFileController.IFileIO;
import readFileModel.MCU32MemoryModel;
import readFileModel.MemoryModel;
import unified.bootloader.modelMccAVR.UBootAVRMCU8Model;

public class BootloadSerialAVRMCU8
extends ACommand<UBootAVRMCU8Model> {
    private static final int retryAttempts = 1;
    private static final int genericTimeout = 1000;
    private static final int eraseTimeout = 20000;
    private static final int RESPONSE_VERSION_H = 11;
    private static final int RESPONSE_VERSION_L = 10;
    private static final int RESPONSE_DEVICE_ID_L = 19;
    private static final int RESPONSE_DEVICE_ID_H = 20;
    private static final int RESPONSE_DEVICE_ID_U = 21;
    private static final int RESPONSE_USER_ID_9 = 33;
    private static final int RESPONSE_USER_ID_8 = 32;
    private static final int RESPONSE_USER_ID_7 = 31;
    private static final int RESPONSE_USER_ID_6 = 30;
    private static final int RESPONSE_USER_ID_5 = 29;
    private static final int RESPONSE_USER_ID_4 = 28;
    private static final int RESPONSE_USER_ID_3 = 27;
    private static final int RESPONSE_USER_ID_2 = 26;
    private static final int RESPONSE_USER_ID_1 = 25;
    private static final int RESPONSE_USER_ID_0 = 24;
    private static final int RESPONSE_DEVICE_SIZE_L = 15;
    private static final int RESPONSE_DEVICE_SIZE_H = 16;
    private static final int RESPONSE_DEVICE_SIZE_U = 17;
    private static final int RESPONSE_DEVICE_SIZE_E = 18;
    private static final int RESPONSE_PAGE_SIZE_H = 23;
    private static final int RESPONSE_PAGE_SIZE_L = 22;
    private static final int RESPONSE_BOOTEND_SIZE = 13;
    private static final int RESPONSE_APPEND_SIZE = 14;
    protected String fileName;
    protected ACommandBase readVersionCommand;
    protected ACommandBase eraseDeviceCommand;
    protected ACommandBase checksumCommand;
    protected ACommandBase resetCommand;
    protected ACommandBase writeCommand;
    protected ACommandBase writeCommandEE;
    protected ACommandBase writeCommandConfig;
    IFileIO fileReader = new HexFileIO();
    protected MemoryModel deviceMemoryModel = new MemoryModel(DeviceArchitecture.AVRMCU8);
    protected BootloaderModel model = new BootloaderModel();
    private static final Logger LOGGER = Logger.getLogger(BootloadSerialAVRMCU8.class.getName());

    public BootloadSerialAVRMCU8() {
        this.retryCount = 1;
        this.timeout = 1;
    }

    public void createCommands() {
        this.readVersionCommand = new CommandReadVersionUART_AVR(((UBootAVRMCU8Model)this.device).getInputStream(), ((UBootAVRMCU8Model)this.device).getOutputStream(), this.deviceMemoryModel);
        this.initializeCommands(this.readVersionCommand, 1, 1000);
    }

    public void createAllExceptReadVersion() {
        this.eraseDeviceCommand = new CommandEraseDeviceUART_AVR(((UBootAVRMCU8Model)this.device).getInputStream(), ((UBootAVRMCU8Model)this.device).getOutputStream(), this.deviceMemoryModel);
        this.checksumCommand = new CommandChecksumUART_AVR(((UBootAVRMCU8Model)this.device).getInputStream(), ((UBootAVRMCU8Model)this.device).getOutputStream(), this.deviceMemoryModel);
        this.resetCommand = new CommandResetDeviceUART_AVR(((UBootAVRMCU8Model)this.device).getInputStream(), ((UBootAVRMCU8Model)this.device).getOutputStream(), this.deviceMemoryModel);
        this.writeCommand = new CommandWriteDeviceFlashUART_AVR(((UBootAVRMCU8Model)this.device).getInputStream(), ((UBootAVRMCU8Model)this.device).getOutputStream(), this.deviceMemoryModel);
        this.initializeCommands(this.eraseDeviceCommand, 1, 20000);
        this.initializeCommands(this.checksumCommand, 1, 1000);
        this.initializeCommands(this.resetCommand, 1, 1000);
        this.initializeCommands(this.writeCommand, 1, 1000);
    }

    public void setMemoryModelForDevice(MemoryModel deviceMemoryModel, int byteAlignedProgramMemorySize, int byteAlignedbootloaderOffset, int byteAlignedEraseRowSize, int setbyteAlignedeepromSize, int byteAlignedConfigMemoryOffset, int setbyteAlignedConfigSize, int byteAlignedeepromMemoryOffset, boolean skipErasedFlashLocationsFlag, int setbyteAlignedWriteBlockSize) {
        deviceMemoryModel.setbyteAlignedprogramMemorySize(byteAlignedProgramMemorySize);
        deviceMemoryModel.setbyteAlignedbootloaderOffset(byteAlignedbootloaderOffset);
        deviceMemoryModel.setbyteAlignedEraseRowSize(byteAlignedEraseRowSize);
        deviceMemoryModel.setbyteAlignedeepromSize(setbyteAlignedeepromSize);
        deviceMemoryModel.setbyteAlignedeepromMemoryOffset(byteAlignedeepromMemoryOffset);
        deviceMemoryModel.setskipErasedFlashLocationsFlag(skipErasedFlashLocationsFlag);
        deviceMemoryModel.setbyteAlignedWriteBlockSize(setbyteAlignedWriteBlockSize);
        deviceMemoryModel.setbyteAlignedconfigurationWordsOffset(byteAlignedConfigMemoryOffset);
        deviceMemoryModel.setbyteAlignedconfigurationWordsSize(setbyteAlignedConfigSize);
        deviceMemoryModel.createProgramMemoryMap();
        deviceMemoryModel.createEEPROMMap();
        deviceMemoryModel.createConfigurationWordsMap();
    }

    public void setMemoryModelForDevice(MCU32MemoryModel mcu32DeviceMemoryModel) {
        mcu32DeviceMemoryModel.createProgramMemoryMap();
    }

    public void initializeCommands(ACommandBase command, int retryCount, int timeout) {
        command.setTimeout(timeout);
        command.setRetryCount(retryCount);
        command.setBootloaderModel(this.model);
    }

    protected void setupDevice() {
        ((UBootAVRMCU8Model)this.device).setConsoleText(this.timeStamp("Device: " + ((UBootAVRMCU8Model)this.device).getDeviceName() + " Bootloading started"));
        LOGGER.log(Level.FINE, String.format("Device: " + ((UBootAVRMCU8Model)this.device).getDeviceName() + " Bootloading started", new Object[0]));
        this.deviceMemoryModel = ((UBootAVRMCU8Model)this.device).ubootPojoAVRMCU8.getDeviceArchitecture().compareTo("Tiny") == 0 ? new MemoryModel(DeviceArchitecture.AVRMCU8) : new MemoryModel(DeviceArchitecture.PIC18);
        this.setMemoryModelForDevice(this.deviceMemoryModel, Integer.parseInt(((UBootAVRMCU8Model)this.device).ubootPojoAVRMCU8.getProgramMemorySize().replace("0x", ""), 16), Integer.parseInt(((UBootAVRMCU8Model)this.device).ubootPojoAVRMCU8.getBootloaderOffset().replace("0x", ""), 16), Integer.parseInt(((UBootAVRMCU8Model)this.device).ubootPojoAVRMCU8.getByteAlignedEraseRowSize().replace("0x", ""), 16), Integer.parseInt(((UBootAVRMCU8Model)this.device).ubootPojoAVRMCU8.getSetbyteAlignedeepromSize().replace("0x", ""), 16), Integer.parseInt(((UBootAVRMCU8Model)this.device).ubootPojoAVRMCU8.getByteAlignedConfigMemoryOffset().replace("0x", ""), 16), Integer.parseInt(((UBootAVRMCU8Model)this.device).ubootPojoAVRMCU8.getSetbyteAlignedConfigSize().replace("0x", ""), 16), Integer.parseInt(((UBootAVRMCU8Model)this.device).ubootPojoAVRMCU8.getByteAlignedeepromMemoryOffset().replace("0x", ""), 16), true, Integer.parseInt(((UBootAVRMCU8Model)this.device).ubootPojoAVRMCU8.getWriteBlockSize().replace("0x", ""), 16));
        this.createCommands();
        this.model.addPropertyChangeListener(new ABootloaderObserver(){

            @Override
            public void handleEvent(BootloaderModel value, String whatChanged, String changed) {
                assert (whatChanged.equals("Version: "));
                byte[] changedBytes = changed.getBytes(Charset.forName("ISO-8859-1"));
                if (changedBytes.length == 32) {
                    LOGGER.log(Level.WARNING, "Legacy/Unrelease AVR format");
                    LOGGER.log(Level.WARNING, "Updated Fomat has (2) additional bytes for Device Size");
                    LOGGER.log(Level.WARNING, "Order is L H (U) (E) with U/E added.");
                }
                int size_0 = changedBytes[15] & 0xFF;
                int size_1 = changedBytes[16] & 0xFF;
                int size_2 = changedBytes[17] & 0xFF;
                int size_3 = changedBytes[18] & 0xFF;
                int sizeMath = 0xFFFFFFFF & (size_3 << 24 | size_2 << 16 | size_1 << 8 | size_0);
                int page_size = changedBytes[23] << 8 & 0xFFFF | changedBytes[22] & 0xFF;
                int partSize = sizeMath * (changedBytes[23] << 8 & 0xFFFF | changedBytes[22] & 0xFF);
                int bootSize = 0;
                bootSize = page_size > 256 ? (changedBytes[13] & 0xFF) * 512 : (changedBytes[13] & 0xFF) * 256;
                int appSize = (changedBytes[14] & 0xFF) * 256;
                int appDataSize = 0;
                int flWr_size = page_size;
                if (appSize != 0) {
                    appDataSize = partSize - appSize;
                } else {
                    appSize = partSize - bootSize;
                }
                String fs = "%s)        BLD_VER: %s.%s          Device ID: 0x%06X           FL_ER: %d           FL_WR: %d           User ID: 0x%02X%04X%04X \nDevice Size: 0x%08X  Bootloader Size: 0x%08X      Application Space: 0x%08X      Application Data Size :0x%08X    ";
                String version = String.format(fs, ((UBootAVRMCU8Model)BootloadSerialAVRMCU8.this.device).getDeviceName(), changedBytes[11], changedBytes[10], changedBytes[21] << 16 & 0xFFFFFF | changedBytes[20] << 8 & 0xFFFF | changedBytes[19] & 0xFF, page_size, flWr_size, changedBytes[33] << 8 & 0xFFFF | changedBytes[32] & 0xFF, changedBytes[31] << 24 & 0xFFFFFFFF | changedBytes[30] << 16 & 0xFFFFFF | changedBytes[29] << 8 & 0xFFFF | changedBytes[28] & 0xFF, changedBytes[27] << 24 & 0xFFFFFFFF | changedBytes[26] << 16 & 0xFFFFFF | changedBytes[25] << 8 & 0xFFFF | changedBytes[24] & 0xFF, partSize, bootSize, appSize, appDataSize);
                ((UBootAVRMCU8Model)BootloadSerialAVRMCU8.this.device).setVersion(version);
                LOGGER.log(Level.FINE, String.format("%s: %s%n", whatChanged, version));
            }
        });
        this.model.addConsolePropertyChangeListener(new ABootloaderObserver(){

            @Override
            public void handleEvent(BootloaderModel value, String whatChanged, String changed) {
                ((UBootAVRMCU8Model)BootloadSerialAVRMCU8.this.device).setProgress(changed);
            }
        });
    }

    @Override
    public void execute() throws TransactionFailureException {
        this.setupDevice();
        this.fileReader.setMemoryModel(this.deviceMemoryModel);
        this.fileName = ((UBootAVRMCU8Model)this.device).ubootPojoAVRMCU8.getFileName();
        if (this.fileName == null || this.fileName.isEmpty()) {
            ((UBootAVRMCU8Model)this.device).setConsoleText(this.timeStamp("Hex File is Invalid"));
            LOGGER.log(Level.SEVERE, "Hex File is Invalid");
            throw new TransactionFailureException("Hex File is Invalid");
        }
        File fp = this.fileReader.fopen(this.fileName);
        this.fileReader.fread(fp);
        ((UBootAVRMCU8Model)this.device).setConsoleText(this.timeStamp("Hex File (re)loaded..."));
        LOGGER.log(Level.FINE, this.timeStamp("Hex File (re)loaded ..."));
        try {
            ((UBootAVRMCU8Model)this.device).setConsoleText(this.timeStamp("(20) Sec Timeout Check per CMD"));
            ((UBootAVRMCU8Model)this.device).setConsoleText(this.timeStamp("Reading Version ..."));
            LOGGER.log(Level.FINE, this.timeStamp("Reading Version ..."));
            ((UBootAVRMCU8Model)this.device).setConsoleText(this.timeStamp("Failure Hint: Check Communication with Device"));
            this.readVersionCommand.executeChain();
            ((UBootAVRMCU8Model)this.device).setConsoleText(this.timeStamp("Bootloader Version Read Successful"));
            LOGGER.log(Level.FINE, this.timeStamp("Bootloader Version Read Successful"));
            String deviceSize = "0x" + ((UBootAVRMCU8Model)this.device).getVersion().subSequence(((UBootAVRMCU8Model)this.device).getVersion().indexOf("Device Size") + 15, ((UBootAVRMCU8Model)this.device).getVersion().indexOf("Bootloader Size") - 2);
            String bootEndSize = "0x" + ((UBootAVRMCU8Model)this.device).getVersion().subSequence(((UBootAVRMCU8Model)this.device).getVersion().indexOf("Bootloader Size") + 19, ((UBootAVRMCU8Model)this.device).getVersion().indexOf("Application Space") - 6);
            String eraseRow = "0x" + Integer.toHexString(Integer.parseInt(((UBootAVRMCU8Model)this.device).getVersion().subSequence(((UBootAVRMCU8Model)this.device).getVersion().indexOf("FL_ER") + 7, ((UBootAVRMCU8Model)this.device).getVersion().indexOf("FL_WR") - 11).toString()));
            String writeBlock = "0x" + Integer.toHexString(Integer.parseInt(((UBootAVRMCU8Model)this.device).getVersion().subSequence(((UBootAVRMCU8Model)this.device).getVersion().indexOf("FL_WR") + 7, ((UBootAVRMCU8Model)this.device).getVersion().indexOf("User ID") - 11).toString()));
            ((UBootAVRMCU8Model)this.device).ubootPojoAVRMCU8.setByteAlignedEraseRowSize(eraseRow);
            this.deviceMemoryModel.setbyteAlignedEraseRowSize(Integer.parseInt(((UBootAVRMCU8Model)this.device).ubootPojoAVRMCU8.getByteAlignedEraseRowSize().replace("0x", ""), 16));
            ((UBootAVRMCU8Model)this.device).ubootPojoAVRMCU8.setWriteBlockSize(writeBlock);
            this.deviceMemoryModel.setbyteAlignedWriteBlockSize(Integer.parseInt(((UBootAVRMCU8Model)this.device).ubootPojoAVRMCU8.getWriteBlockSize().replace("0x", ""), 16));
            ((UBootAVRMCU8Model)this.device).ubootPojoAVRMCU8.setBootloaderOffset(bootEndSize);
            this.deviceMemoryModel.setbyteAlignedbootloaderOffset(Integer.parseInt(((UBootAVRMCU8Model)this.device).ubootPojoAVRMCU8.getBootloaderOffset().replace("0x", ""), 16));
            ((UBootAVRMCU8Model)this.device).ubootPojoAVRMCU8.setProgramMemorySize(deviceSize);
            this.deviceMemoryModel.setbyteAlignedprogramMemorySize(Integer.parseInt(((UBootAVRMCU8Model)this.device).ubootPojoAVRMCU8.getProgramMemorySize().replace("0x", ""), 16));
            this.createAllExceptReadVersion();
            ((UBootAVRMCU8Model)this.device).setConsoleText(this.timeStamp("Erasing Device ..."));
            LOGGER.log(Level.FINE, this.timeStamp("Erasing Device ..."));
            ((UBootAVRMCU8Model)this.device).setConsoleText(this.timeStamp("Failure Hint: Confirm Erase Range"));
            this.eraseDeviceCommand.executeChain();
            ((UBootAVRMCU8Model)this.device).setConsoleText(this.timeStamp("Erase Successful"));
            LOGGER.log(Level.FINE, this.timeStamp("Erase Successful"));
            ((UBootAVRMCU8Model)this.device).setConsoleText(this.timeStamp("Programming Flash ..."));
            LOGGER.log(Level.FINE, this.timeStamp("Programming Flash ..."));
            ((UBootAVRMCU8Model)this.device).setConsoleText(this.timeStamp("Failure Hint: Confirm Hex Offset"));
            this.writeCommand.executeChain();
            ((UBootAVRMCU8Model)this.device).setConsoleText(this.timeStamp("Flashed Programmed"));
            LOGGER.log(Level.FINE, this.timeStamp("Flashed Programmed"));
            ((UBootAVRMCU8Model)this.device).setConsoleText(this.timeStamp("Retrieving Checksum ..."));
            LOGGER.log(Level.FINE, this.timeStamp("Retrieving Checksum ..."));
            ((UBootAVRMCU8Model)this.device).setConsoleText(this.timeStamp("Failure Hint: Check Build Properties"));
            this.checksumCommand.executeChain();
            ((UBootAVRMCU8Model)this.device).setConsoleText(this.timeStamp("Checksum Matched"));
            LOGGER.log(Level.FINE, this.timeStamp("Checksum Matched"));
            ((UBootAVRMCU8Model)this.device).setConsoleText(this.timeStamp("Resetting Device"));
            LOGGER.log(Level.FINE, this.timeStamp("Resetting Device"));
            this.resetCommand.executeChain();
            ((UBootAVRMCU8Model)this.device).setConsoleText(this.timeStamp("Device Reset"));
            LOGGER.log(Level.FINE, this.timeStamp("Device Reset"));
            ((UBootAVRMCU8Model)this.device).setConsoleText(this.timeStamp("FULL Bootloader SUCCESSFUL"));
            ((UBootAVRMCU8Model)this.device).setConsoleText(this.timeStamp("Device: " + ((UBootAVRMCU8Model)this.device).getDeviceName() + " Bootloading Successful"));
            LOGGER.log(Level.FINE, this.timeStamp("Device: " + ((UBootAVRMCU8Model)this.device).getDeviceName() + " Bootloading Successful"));
        }
        catch (TransactionFailureException ex) {
            ((UBootAVRMCU8Model)this.device).setConsoleText(this.timeStamp("Device Failed to respond to command..."));
            LOGGER.log(Level.SEVERE, "Chain Exception Thrown: ", ex);
        }
    }

    @Override
    public void setDataModel(UBootAVRMCU8Model model) {
        this.device = model;
    }

    @Override
    public UBootAVRMCU8Model getDataModel() {
        return (UBootAVRMCU8Model)this.device;
    }
}

