/*
 * Decompiled with CFR 0.152.
 */
package unified.bootloader.model32bit;

import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import unified.bootloader.model32bit.UBootModel32bit;

public class UBootPoJo32bit {
    UBootModel32bit model;
    private String programMemorySize = "0x4000";
    private String bootloaderOffset = "0x400";
    private String byteAlignedEraseRowSize = "0x40";
    private String setbyteAlignedeepromSize = "0x40";
    private String byteAlignedeepromMemoryOffset = "0x1E000";
    private String byteAlignedConfigMemoryOffset = "0x30000";
    private String setbyteAlignedConfigSize = "0x0E";
    private String writeBlockSize = "0x20";
    private String deviceArchitecture;
    private String programEEData = "Disabled";
    private String programConfigurationWords = "Disabled";
    private String fileName = null;
    private final SimpleStringProperty communicationProtocol = new SimpleStringProperty();
    private final SimpleBooleanProperty configurationState = new SimpleBooleanProperty(false);
    private final SimpleBooleanProperty consoleState = new SimpleBooleanProperty(false);
    private String configurationChanged;
    private String uartComPort;
    private String usbDevice;
    private String uartBaudRate;
    private String uartDataBits;
    private String uartStopBits;
    private String uartParity;

    public UBootPoJo32bit(UBootModel32bit model) {
        this.model = model;
    }

    public synchronized void setProgramEEData(String programEEData) {
        this.programEEData = programEEData;
    }

    public synchronized void setProgramConfigurationWords(String programConfigurationWords) {
        this.programConfigurationWords = programConfigurationWords;
    }

    public synchronized void setWriteBlockSize(String writeBlockSize) {
        this.writeBlockSize = writeBlockSize;
        this.model.callWriteBlockSizeObservers();
    }

    public synchronized void setByteAlignedConfigMemoryOffset(String byteAlignedConfigMemoryOffset) {
        this.byteAlignedConfigMemoryOffset = byteAlignedConfigMemoryOffset;
    }

    public synchronized void setSetbyteAlignedConfigSize(String setbyteAlignedConfigSize) {
        this.setbyteAlignedConfigSize = setbyteAlignedConfigSize;
    }

    public synchronized void setByteAlignedEraseRowSize(String byteAlignedEraseRowSize) {
        this.byteAlignedEraseRowSize = byteAlignedEraseRowSize;
    }

    public synchronized void setSetbyteAlignedeepromSize(String setbyteAlignedeepromSize) {
        this.setbyteAlignedeepromSize = setbyteAlignedeepromSize;
    }

    public synchronized void setByteAlignedeepromMemoryOffset(String byteAlignedeepromMemoryOffset) {
        this.byteAlignedeepromMemoryOffset = byteAlignedeepromMemoryOffset;
    }

    public synchronized String getProgramEEData() {
        return this.programEEData;
    }

    public synchronized String getProgramConfigurationWords() {
        return this.programConfigurationWords;
    }

    public synchronized String getWriteBlockSize() {
        return this.writeBlockSize;
    }

    public synchronized String getByteAlignedConfigMemoryOffset() {
        return this.byteAlignedConfigMemoryOffset;
    }

    public synchronized String getSetbyteAlignedConfigSize() {
        return this.setbyteAlignedConfigSize;
    }

    public synchronized String getByteAlignedEraseRowSize() {
        return this.byteAlignedEraseRowSize;
    }

    public synchronized String getSetbyteAlignedeepromSize() {
        return this.setbyteAlignedeepromSize;
    }

    public synchronized String getByteAlignedeepromMemoryOffset() {
        return this.byteAlignedeepromMemoryOffset;
    }

    public synchronized String getDeviceArchitecture() {
        return this.deviceArchitecture;
    }

    public synchronized String getProgramMemorySize() {
        return this.programMemorySize;
    }

    public synchronized String getBootloaderOffset() {
        return this.bootloaderOffset;
    }

    public synchronized void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public synchronized String getFileName() {
        return this.fileName;
    }

    public synchronized void setProtocolType(String protocolType) {
        this.model.ubootPojo32Bit.communicationProtocol.set(protocolType);
        this.model.callObservers();
    }

    public synchronized SimpleStringProperty getProtocolType() {
        return this.communicationProtocol;
    }

    public synchronized void setConfigurationChangedState(boolean state) {
        this.configurationState.setValue(Boolean.valueOf(state));
    }

    public synchronized SimpleBooleanProperty getConfigurationChangedState() {
        return this.configurationState;
    }

    public synchronized void setConfigurationChanged(String state) {
        this.configurationChanged = state;
    }

    public synchronized String getConfigurationChanged() {
        return this.configurationChanged;
    }

    public synchronized void setComPort(String comPort) {
        this.model.ubootPojo32Bit.uartComPort = comPort;
        this.model.callObservers();
    }

    public synchronized String getComPort() {
        return this.uartComPort;
    }

    public synchronized void setUsbDevice(String device) {
        this.model.ubootPojo32Bit.usbDevice = device;
        this.model.callObservers();
    }

    public synchronized String getUsbDevice() {
        return this.usbDevice;
    }

    public synchronized void setBaudRate(String bitPerSec) {
        this.model.ubootPojo32Bit.uartBaudRate = bitPerSec;
        this.model.callObservers();
    }

    public synchronized String getBaudRate() {
        return this.uartBaudRate;
    }

    public synchronized void setDataBits(String dataBits) {
        this.model.ubootPojo32Bit.uartDataBits = dataBits;
        this.model.callObservers();
    }

    public synchronized String getDataBits() {
        return this.uartDataBits;
    }

    public synchronized void setStopBits(String stopBits) {
        this.model.ubootPojo32Bit.uartStopBits = stopBits;
        this.model.callObservers();
    }

    public synchronized String getStopBits() {
        return this.uartStopBits;
    }

    public synchronized void setParity(String parity) {
        this.model.ubootPojo32Bit.uartParity = parity;
        this.model.callObservers();
    }

    public synchronized String getParity() {
        return this.uartParity;
    }

    public synchronized void setConsoleState(boolean state) {
        this.consoleState.setValue(Boolean.valueOf(state));
    }

    public synchronized SimpleBooleanProperty getConsoleState() {
        return this.consoleState;
    }
}

