/*
 * Decompiled with CFR 0.152.
 */
package unified.bootloader16bit;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import unified.bootloader16bit.Command;
import unified.bootloader16bit.FnAddWord;
import unified.bootloader16bit.FnAddressAccessor;
import unified.bootloader16bit.FnCommandAccessor;
import unified.bootloader16bit.FnDataAccessor;
import unified.bootloader16bit.FnDataLengthAccessor;
import unified.bootloader16bit.FnUnlockAccessor;
import unified.bootloader16bit.PropAddress;
import unified.bootloader16bit.PropCommand;
import unified.bootloader16bit.PropDeviceId;
import unified.bootloader16bit.PropDummy;
import unified.bootloader16bit.PropEndAddress;
import unified.bootloader16bit.PropErasePageSize;
import unified.bootloader16bit.PropLength;
import unified.bootloader16bit.PropMaxPacketSize;
import unified.bootloader16bit.PropMinWriteSize;
import unified.bootloader16bit.PropProgramEndAddress;
import unified.bootloader16bit.PropProgramRegionId;
import unified.bootloader16bit.PropProgramStartAddress;
import unified.bootloader16bit.PropStartAddress;
import unified.bootloader16bit.PropStatus;
import unified.bootloader16bit.PropUnlockCode;
import unified.bootloader16bit.PropVersion;

abstract class DefaultCommand
implements Command {
    DefaultCommand() {
    }

    @Override
    public void write(ByteBuffer bb) {
        bb.put(this.accept(new FnCommandAccessor()));
        bb.putShort(this.accept(new FnDataLengthAccessor()).shortValue());
        bb.putInt(this.accept(new FnUnlockAccessor()).intValue());
        bb.putInt(this.accept(new FnAddressAccessor()).intValue());
        this.accept(new FnDataAccessor()).accept(bb);
    }

    @Override
    public int size() {
        ByteBuffer bb = ByteBuffer.allocate(1024);
        bb.order(ByteOrder.LITTLE_ENDIAN);
        this.write(bb);
        bb.flip();
        return bb.limit();
    }

    @Override
    public Command setAddress(long address) {
        return new PropAddress(this, address);
    }

    @Override
    public Command setUnlock(long unlock) {
        return new PropUnlockCode(this, unlock);
    }

    @Override
    public Command setLength(int length) {
        return new PropLength(this, length);
    }

    @Override
    public Command setCommand(int cmd) {
        return new PropCommand(this, cmd);
    }

    @Override
    public Command addWord(int data) {
        return this.accept(new FnAddWord(data));
    }

    @Override
    public Command setStatus(int status) {
        return new PropStatus(this, status);
    }

    @Override
    public Command setVersion(int version) {
        return new PropVersion(this, version);
    }

    @Override
    public Command setDeviceId(int deviceId) {
        return new PropDeviceId(this, deviceId);
    }

    @Override
    public Command setEndAddress(long endAddress) {
        return new PropEndAddress(this, endAddress);
    }

    @Override
    public Command setStartAddress(long startAddress) {
        return new PropStartAddress(this, startAddress);
    }

    @Override
    public Command setErasePageSize(int erasePageSize) {
        return new PropErasePageSize(this, erasePageSize);
    }

    @Override
    public Command setMaxPacketSize(int maxPacketSize) {
        return new PropMaxPacketSize(this, maxPacketSize);
    }

    @Override
    public Command setMinWriteSize(int minWriteSize) {
        return new PropMinWriteSize(this, minWriteSize);
    }

    @Override
    public Command setDummy(Object notUsed, int size) {
        return new PropDummy(this, size);
    }

    @Override
    public Command setProgramStartAddress(long startAddress) {
        return new PropProgramStartAddress(this, startAddress);
    }

    @Override
    public Command setProgramEndAddress(long endAddress) {
        return new PropProgramEndAddress(this, endAddress);
    }

    @Override
    public Command setProgramRegionId(int region) {
        return new PropProgramRegionId(this, region);
    }
}

