/*
 * Decompiled with CFR 0.152.
 */
package unified.bootloader16bit;

import unified.bootloader16bit.Command;
import unified.bootloader16bit.FnCommandVisitor;
import unified.bootloader16bit.PropAddress;
import unified.bootloader16bit.PropCommand;
import unified.bootloader16bit.PropCommandBase;
import unified.bootloader16bit.PropDeviceId;
import unified.bootloader16bit.PropDummy;
import unified.bootloader16bit.PropEndAddress;
import unified.bootloader16bit.PropErasePageSize;
import unified.bootloader16bit.PropLength;
import unified.bootloader16bit.PropMaxPacketSize;
import unified.bootloader16bit.PropMinWriteSize;
import unified.bootloader16bit.PropProgramEndAddress;
import unified.bootloader16bit.PropProgramRegionId;
import unified.bootloader16bit.PropProgramStartAddress;
import unified.bootloader16bit.PropProgramWord;
import unified.bootloader16bit.PropStartAddress;
import unified.bootloader16bit.PropStatus;
import unified.bootloader16bit.PropUnlockCode;
import unified.bootloader16bit.PropVersion;

class FnAddWord
implements FnCommandVisitor<Command> {
    private final int data;

    FnAddWord(int data) {
        this.data = data;
    }

    @Override
    public Command forBase() {
        return new PropProgramWord(new PropCommandBase(), this.data);
    }

    @Override
    public Command forStartAddress(Command others, long startAddress) {
        return new PropStartAddress(others, startAddress);
    }

    @Override
    public Command forDummy(Command others, int size) {
        return new PropDummy(others, size);
    }

    @Override
    public Command forVersion(Command others, int version) {
        return new PropVersion(others, version);
    }

    @Override
    public Command forMinWriteSize(Command others, int minWriteSize) {
        return new PropMinWriteSize(others, minWriteSize);
    }

    @Override
    public Command forMaxPacketSize(Command others, int maxPacketSize) {
        return new PropMaxPacketSize(others, maxPacketSize);
    }

    @Override
    public Command forErasePageSize(Command others, int erasePageSize) {
        return new PropErasePageSize(others, erasePageSize);
    }

    @Override
    public Command forEndAddress(Command others, long endAddress) {
        return new PropEndAddress(others, endAddress);
    }

    @Override
    public Command forDeviceId(Command others, int deviceId) {
        return new PropDeviceId(others, deviceId);
    }

    @Override
    public Command forCommand(Command others, int cmd) {
        return new PropCommand(others.accept(this), cmd);
    }

    @Override
    public Command forLength(Command others, int length) {
        return new PropLength(others.accept(this), length);
    }

    @Override
    public Command forUnlock(Command others, long unlock) {
        return new PropUnlockCode(others.accept(this), unlock);
    }

    @Override
    public Command forAddress(Command others, long address) {
        return new PropAddress(others.accept(this), address);
    }

    @Override
    public Command forData(Command others, int data) {
        return new PropProgramWord(others.accept(this), data);
    }

    @Override
    public Command forStatus(Command others, int status) {
        return new PropStatus(others.accept(this), status);
    }

    @Override
    public Command forProgramEndAddress(Command others, long endAddress) {
        return new PropProgramEndAddress(others, endAddress);
    }

    @Override
    public Command forProgramStartAddress(Command others, long startAddress) {
        return new PropProgramStartAddress(others, startAddress);
    }

    @Override
    public Command forProgramRegionId(Command others, int programRegion) {
        return new PropProgramRegionId(others, programRegion);
    }
}

