/*
 * Decompiled with CFR 0.152.
 */
package unified.bootloader16bit;

import unified.bootloader16bit.Command;
import unified.bootloader16bit.FnCommandVisitor;

public class FnToStringVerbose
implements FnCommandVisitor<String> {
    public static String accept(Command command) {
        return "{" + command.accept(new FnToStringVerbose()) + "}";
    }

    @Override
    public String forDummy(Command others, int size) {
        return "XX " + others.accept(this);
    }

    @Override
    public String forVersion(Command others, int version) {
        return String.format("version=%04X%n", version) + others.accept(this);
    }

    @Override
    public String forMinWriteSize(Command others, int minWriteSize) {
        return String.format("minWriteSize=%04X%n", minWriteSize) + others.accept(this);
    }

    @Override
    public String forMaxPacketSize(Command others, int maxPacketSize) {
        return String.format("maxPacketSize=%04X%n", maxPacketSize) + others.accept(this);
    }

    @Override
    public String forErasePageSize(Command others, int erasePageSize) {
        return String.format("erasePageSize=%04X%n", erasePageSize) + others.accept(this);
    }

    @Override
    public String forStartAddress(Command others, long startAddress) {
        return String.format("startAddress=%08X%n", startAddress) + others.accept(this);
    }

    @Override
    public String forEndAddress(Command others, long endAddress) {
        return String.format("endAddress=%08X%n", endAddress) + others.accept(this);
    }

    @Override
    public String forDeviceId(Command others, int deviceId) {
        return String.format("deviceId=%04X%n", deviceId) + others.accept(this);
    }

    @Override
    public String forBase() {
        return "";
    }

    @Override
    public String forCommand(Command others, int cmd) {
        return String.format("command=0x%02X%n", cmd) + others.accept(this);
    }

    @Override
    public String forLength(Command others, int length) {
        return String.format("length=0x%04X%n", length) + others.accept(this);
    }

    @Override
    public String forUnlock(Command others, long unlock) {
        return String.format("unlock=0x%08X%n", unlock) + others.accept(this);
    }

    @Override
    public String forAddress(Command others, long address) {
        return String.format("address=0x%08X%n", address) + others.accept(this);
    }

    @Override
    public String forData(Command others, int data) {
        return String.format("data=0x%08X%n", data) + others.accept(this);
    }

    @Override
    public String forProgramEndAddress(Command others, long endAddress) {
        return String.format("programEndAddress=0x%08X%n", endAddress) + others.accept(this);
    }

    @Override
    public String forProgramStartAddress(Command others, long startAddress) {
        return String.format("programStartAddress=0x%08X%n", startAddress) + others.accept(this);
    }

    @Override
    public String forProgramRegionId(Command others, int region) {
        return String.format("programRegion=0x%08X%n", region) + others.accept(this);
    }

    @Override
    public String forStatus(Command others, int status) {
        String statusString;
        switch (status & 0xFF) {
            case 1: {
                statusString = "Success";
                break;
            }
            case 255: {
                statusString = "Command Unsupported";
                break;
            }
            case 254: {
                statusString = "Invalid Address";
                break;
            }
            case 253: {
                statusString = "Invalid Length";
                break;
            }
            default: {
                statusString = "Unknown Status";
            }
        }
        return String.format("status=0x%02X (%s)%n", (byte)status, statusString) + others.accept(this);
    }
}

