/*
 * Decompiled with CFR 0.152.
 */
package unified.bootloader16bit;

public class FromAscii {
    private FromAscii() {
    }

    private static byte codeToNibble(byte code) {
        switch (code) {
            case 48: {
                return 0;
            }
            case 49: {
                return 1;
            }
            case 50: {
                return 2;
            }
            case 51: {
                return 3;
            }
            case 52: {
                return 4;
            }
            case 53: {
                return 5;
            }
            case 54: {
                return 6;
            }
            case 55: {
                return 7;
            }
            case 56: {
                return 8;
            }
            case 57: {
                return 9;
            }
            case 65: {
                return 10;
            }
            case 66: {
                return 11;
            }
            case 67: {
                return 12;
            }
            case 68: {
                return 13;
            }
            case 69: {
                return 14;
            }
            case 70: {
                return 15;
            }
            case 97: {
                return 10;
            }
            case 98: {
                return 11;
            }
            case 99: {
                return 12;
            }
            case 100: {
                return 13;
            }
            case 101: {
                return 14;
            }
            case 102: {
                return 15;
            }
        }
        throw new NumberFormatException("Invalid ASCII number valid: " + code);
    }

    public static byte toByte(String ascii) {
        if (ascii.length() != 2) {
            throw new NumberFormatException("Converting String to Byte requires exactly 2 ASCII characters but length was " + ascii.length());
        }
        return (byte)(FromAscii.codeToNibble((byte)ascii.charAt(0)) * 16 + FromAscii.codeToNibble((byte)ascii.charAt(1)));
    }

    public static int toInt16(String ascii) {
        if (ascii.length() != 4) {
            throw new NumberFormatException("Converting String to Int16 requires exactly 4 ASCII characters but length was " + ascii.length());
        }
        int upperByte = FromAscii.removeSignExtention(FromAscii.toByte(ascii.substring(0, 2)));
        int lowerByte = FromAscii.removeSignExtention(FromAscii.toByte(ascii.substring(2, 4)));
        return upperByte * 256 + lowerByte;
    }

    private static int removeSignExtention(byte data) {
        return data & 0xFF;
    }
}

