/*
 * Decompiled with CFR 0.152.
 */
package unified.bootloader16bit.phy;

import java.util.Collections;
import java.util.List;
import java.util.Observable;
import java.util.Optional;
import java.util.function.Supplier;

public abstract class AModel
extends Observable {
    protected static final Supplier<List<String>> NO_PORTS_SUPPLIER = Collections::emptyList;
    protected Supplier<List<String>> portSupplier = NO_PORTS_SUPPLIER;
    protected static final String NO_PORT_SELECTED = "";
    protected String port = "";

    public void setPortSupplier(Supplier<List<String>> portSupplier) {
        this.portSupplier = Optional.ofNullable(portSupplier).orElse(NO_PORTS_SUPPLIER);
        if (!this.isPortSelected()) {
            this.selectDefaultPort();
        }
    }

    protected void selectDefaultPort() {
        List<String> ports = this.getPorts();
        this.port = ports.isEmpty() ? NO_PORT_SELECTED : ports.get(0);
    }

    public boolean isPortSelected() {
        return this.port != null && !this.port.isEmpty();
    }

    public final List<String> getPorts() {
        return Optional.ofNullable(this.portSupplier.get()).orElseGet(NO_PORTS_SUPPLIER);
    }

    public String getPort() {
        if (!this.isPortSelected()) {
            this.selectDefaultPort();
        }
        return this.port;
    }

    public void setPort(String port) {
        if (this.getPorts().contains(port)) {
            this.port = port;
            this.setChanged();
            this.notifyObservers();
        }
    }
}

