/*
 * Decompiled with CFR 0.152.
 */
package unified.bootloader16bit.phy;

import java.math.BigDecimal;
import java.math.RoundingMode;

public class Bitrate {
    private final int bitrate;
    private static final String BITS_PER_SECOND = "bits/s";
    private static final String K_BITS_PER_SECOND = "kbits/s";
    private static final String M_BITS_PER_SECOND = "Mbits/s";

    public Bitrate(int bitrate) {
        this.bitrate = bitrate;
    }

    static String bitrateToString(int bitrate) {
        BigDecimal decimalBitrate = new BigDecimal(bitrate);
        if (bitrate < 1000) {
            return decimalBitrate.toString() + " " + BITS_PER_SECOND;
        }
        if (bitrate < 1000000) {
            decimalBitrate = decimalBitrate.divide(new BigDecimal(1000));
            return decimalBitrate.setScale(2, RoundingMode.FLOOR) + " " + K_BITS_PER_SECOND;
        }
        decimalBitrate = decimalBitrate.divide(new BigDecimal(1000000));
        return decimalBitrate.setScale(2, RoundingMode.FLOOR) + " " + M_BITS_PER_SECOND;
    }

    public int getRate() {
        return this.bitrate;
    }

    public String toString() {
        return Bitrate.bitrateToString(this.bitrate);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        return ((Bitrate)object).getRate() == this.bitrate;
    }

    public int hashCode() {
        int hash = 7;
        hash = 29 * hash + this.bitrate;
        return hash;
    }
}

