/*
 * Decompiled with CFR 0.152.
 */
package unified.bootloader16bit.phy.can;

import java.util.HashMap;

class CanPeakFDInitString {
    private Integer nominalRate;
    private Integer dataRate;
    private static final HashMap<Integer, String> nominalRateMap = new HashMap();
    private static final HashMap<Integer, String> dataRateMap;

    private CanPeakFDInitString(CANPeakFDInitStringBuilder builder) {
        this.nominalRate = builder.nominalRate;
        this.dataRate = builder.dataRate;
    }

    public String get() {
        return "f_clock=80000000," + nominalRateMap.get(this.nominalRate) + "," + dataRateMap.get(this.dataRate);
    }

    static {
        nominalRateMap.put(125000, "nom_brp=8,nom_tseg1=63,nom_tseg2=16,nom_sjw=16");
        nominalRateMap.put(250000, "nom_brp=8,nom_tseg1=31,nom_tseg2=8,nom_sjw=8");
        nominalRateMap.put(500000, "nom_brp=4,nom_tseg1=31,nom_tseg2=8,nom_sjw=8");
        nominalRateMap.put(1000000, "nom_brp=2,nom_tseg1=31,nom_tseg2=8,nom_sjw=8");
        dataRateMap = new HashMap();
        dataRateMap.put(1538000, "data_brp=2,data_tseg1=20,data_tseg2=5,data_sjw=5");
        dataRateMap.put(2000000, "data_brp=1,data_tseg1=31,data_tseg2=8,data_sjw=8");
        dataRateMap.put(3077000, "data_brp=1,data_tseg1=20,data_tseg2=5,data_sjw=5");
        dataRateMap.put(4000000, "data_brp=4,data_tseg1=3,data_tseg2=1,data_sjw=1");
        dataRateMap.put(5000000, "data_brp=1,data_tseg1=12,data_tseg2=3,data_sjw=3");
        dataRateMap.put(6666667, "data_brp=1,data_tseg1=9,data_tseg2=2,data_sjw=2");
        dataRateMap.put(8000000, "data_brp=1,data_tseg1=7,data_tseg2=2,data_sjw=2");
    }

    public static class CANPeakFDInitStringBuilder {
        private Integer nominalRate = 500000;
        private Integer dataRate = 2000000;

        public CANPeakFDInitStringBuilder withNominalRate(Integer nominalRate) {
            this.nominalRate = nominalRate;
            return this;
        }

        public CANPeakFDInitStringBuilder withDataRate(Integer dataRate) {
            this.dataRate = dataRate;
            return this;
        }

        public CanPeakFDInitString build() {
            return new CanPeakFDInitString(this);
        }
    }
}

