/*
 * Decompiled with CFR 0.152.
 */
package unified.bootloader16bit.phy.can;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import unified.bootloader16bit.phy.can.CanMapping;
import unified.bootloader16bit.phy.can.CanNetAddrInfo;
import unified.bootloader16bit.phy.can.CanTpApi;

public class LibMain {
    public static void main(String[] args) {
        LibMain libMain = new LibMain();
        libMain.run();
    }

    private void run() {
        int PCAN_USBBUS1 = 81;
        int PCAN_USBBUS2 = 82;
        int PCAN_USBBUS3 = 83;
        boolean PCANTP_CAN_MSGTYPE_STANDARD = false;
        int PCANTP_CAN_MSGTYPE_EXTENDED = 2;
        boolean PCANTP_ISOTP_ADDRESSING_PHYSICAL = true;
        boolean PCANTP_ISOTP_FORMAT_NORMAL = true;
        boolean PCANTP_ISOTP_MSGTYPE_DIAGNOSTIC = true;
        boolean dlc = false;
        CanTpApi tp = new CanTpApi();
        tp.isHardwareAvailable(81);
        tp.isHardwareAvailable(82);
        tp.isHardwareAvailable(83);
        tp.initialize(81, 250000);
        CanNetAddrInfo canNetAddrInfo = new CanNetAddrInfo(1, 1, 1, 241, 1, 1);
        CanMapping mapping = new CanMapping(161, 162, 0, 0, canNetAddrInfo);
        CanMapping reverse = new CanMapping(mapping.getCanIdFlowCtrl(), mapping.getCanId(), 2, 0, new CanNetAddrInfo(1, 1, 1, mapping.getCanNetAddrInfo().getTargetAddr(), mapping.getCanNetAddrInfo().getSourceAddr(), 1));
        tp.setMapping(mapping);
        tp.addMapping();
        tp.setMapping(reverse);
        tp.addMapping();
        tp.setMapping(mapping);
        ByteBuffer in = ByteBuffer.allocate(10000);
        in.order(ByteOrder.LITTLE_ENDIAN);
        ByteBuffer out = ByteBuffer.allocate(10000);
        out.order(ByteOrder.LITTLE_ENDIAN);
        in.clear();
        in.put((byte)0);
        in.put((byte)0);
        in.put((byte)0);
        in.put((byte)0);
        in.put((byte)0);
        in.put((byte)0);
        in.put((byte)0);
        in.put((byte)0);
        in.put((byte)0);
        in.put((byte)0);
        in.put((byte)0);
        in.flip();
        out.clear();
        tp.transceive(in, out, 2000);
        in.clear();
        in.put((byte)11);
        in.put((byte)8);
        in.put((byte)0);
        in.put((byte)0);
        in.put((byte)0);
        in.put((byte)0);
        in.put((byte)0);
        in.put((byte)0);
        in.put((byte)0);
        in.put((byte)0);
        in.put((byte)0);
        in.flip();
        out.clear();
        tp.transceive(in, out, 2000);
        tp.uninitialize();
    }

    static {
        System.loadLibrary("PCAN-ISO-TP");
        System.loadLibrary("ubhapeakcanadapterdll");
    }
}

