/*
 * Decompiled with CFR 0.152.
 */
package unified.bootloader16bit.phy.i2c;

import java.util.Arrays;
import java.util.Optional;

public enum I2cErrorCode {
    E_NO_ERR(0),
    E_ERR_UNKNOWN_ERROR(-1),
    E_ERR_CMD_FAILED(-2),
    E_ERR_INVALID_HANDLE(-3),
    E_ERR_INVALID_PARAMETER(-4),
    E_ERR_INVALID_PASS(-5),
    E_ERR_PASSWORD_LIMIT_REACHED(-6),
    E_ERR_FLASH_WRITE_PROTECTED(-7),
    E_ERR_NULL(-10),
    E_ERR_DESTINATION_TOO_SMALL(-11),
    E_ERR_INPUT_TOO_LARGE(-12),
    E_ERR_FLASH_WRITE_FAILED(-13),
    E_ERR_NO_SUCH_INDEX(-101),
    E_ERR_DEVICE_NOT_FOUND(-103),
    E_ERR_INTERNAL_BUFFER_TOO_SMALL(-104),
    E_ERR_OPEN_DEVICE_ERROR(-105),
    E_ERR_CONNECTION_ALREADY_OPENED(-106),
    E_ERR_CLOSE_FAILED(-107),
    E_ERR_RAW_TX_TOO_LARGE(-301),
    E_ERR_RAW_TX_COPYFAILED(-302),
    E_ERR_RAW_RX_COPYFAILED(-303),
    E_ERR_INVALID_SPEED(-401),
    E_ERR_SPEED_NOT_SET(-402),
    E_ERR_INVALID_BYTE_NUMBER(-403),
    E_ERR_INVALID_ADDRESS(-404),
    E_ERR_I2C_BUSY(-405),
    E_ERR_I2C_READ_ERROR(-406),
    E_ERR_ADDRESS_NACK(-407),
    E_ERR_I2C_TIMEOUT(-408),
    E_ERR_TOO_MANY_RX_BYTES(-409),
    E_ERR_COPY_RX_DATA_FAILED(-410),
    E_ERR_NO_EFFECT(-411),
    E_ERR_COPY_TX_DATA_FAILED(-412),
    E_ERR_INVALID_PEC(-413),
    E_ERR_BLOCK_SIZE_MISMATCH(-414),
    E_ERR_LOAD_DLL(-1000),
    E_ERR_FUNCTION_NOT_FOUND(-10000);

    private final int code;

    private I2cErrorCode(int code) {
        this.code = code;
    }

    public static I2cErrorCode getError(int code) {
        Optional<I2cErrorCode> errorCode = Arrays.stream(I2cErrorCode.values()).filter(error -> error.code == code).findFirst();
        return errorCode.orElse(E_ERR_UNKNOWN_ERROR);
    }

    public static String getErrorName(int code) {
        return I2cErrorCode.getError(code).toString();
    }

    public boolean isError() {
        return this.code != 0;
    }
}

