/*
 * Decompiled with CFR 0.152.
 */
package unified.bootloader16bit.phy.lin;

import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FrameFormatId {
    private final Integer upperLimit;
    private final Integer lowerLimit;
    private static final Pattern ID_HEX_PATTERN = Pattern.compile("(0x)?(?<value>[0-9a-fA-F]{1,8})");
    private static final Pattern ID_HEX_NUMBER_PATTERN = Pattern.compile("(0x)?[0-9a-fA-F]+");

    FrameFormatId(int lowerLimit, int upperLimit) {
        this.lowerLimit = lowerLimit;
        this.upperLimit = upperLimit;
    }

    FrameFormatId(int upperLimit) {
        this(0, upperLimit);
    }

    public String getRangeString() {
        return "0x" + Integer.toHexString(this.lowerLimit).toUpperCase() + "-0x" + Integer.toHexString(this.upperLimit).toUpperCase();
    }

    public Optional<Integer> getId(String id) {
        Matcher matcher = ID_HEX_PATTERN.matcher(id.trim());
        if (matcher.matches()) {
            Integer value;
            try {
                value = Integer.parseInt(matcher.group("value"), 16);
            }
            catch (NumberFormatException e) {
                return Optional.empty();
            }
            if (value > this.upperLimit || value < this.lowerLimit) {
                return Optional.empty();
            }
            return Optional.of(value);
        }
        return Optional.empty();
    }

    public boolean isValidString(String id) {
        return this.getId(id).isPresent();
    }

    public boolean isNumber(String id) {
        Matcher matcher = ID_HEX_NUMBER_PATTERN.matcher(id.trim());
        return matcher.matches();
    }
}

