/*
 * Decompiled with CFR 0.152.
 */
package unified.bootloader16bit.phy.lin;

import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import unified.bootloader16bit.phy.AModel;
import unified.bootloader16bit.phy.lin.ChecksumType;

class Model
extends AModel {
    private String publisherId;
    private String subscriberId;
    private String nodeId;
    private String serviceId;
    private Integer dataBitRate;
    private boolean isDataRateEnabled;
    private ChecksumType checksum;

    public Model() {
        this(Collections::emptyList);
    }

    public Model(Supplier<List<String>> portSupplier) {
        this.portSupplier = portSupplier;
        this.publisherId = "0x05";
        this.subscriberId = "0x06";
        this.nodeId = "0x03";
        this.serviceId = "0xC9";
        this.checksum = ChecksumType.CLASSIC;
        this.dataBitRate = 9600;
        this.isDataRateEnabled = false;
    }

    public void setPublisherId(String id) {
        this.publisherId = id;
    }

    public String getPublisherId() {
        return this.publisherId;
    }

    public void setSubscriberId(String id) {
        this.subscriberId = id;
    }

    public String getSubscriberId() {
        return this.subscriberId;
    }

    public void setNodeId(String id) {
        this.nodeId = id;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public void setServiceId(String id) {
        this.serviceId = id;
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public void setChecksumType(ChecksumType id) {
        this.checksum = id;
    }

    public ChecksumType getChecksumType() {
        return this.checksum;
    }

    public int getChecksumIndex() {
        return this.checksum.ordinal();
    }

    public int getDataBitRate() {
        return this.dataBitRate;
    }

    public void setDataBitRate(Integer bitRate) {
        this.dataBitRate = bitRate;
    }

    public boolean isDataBitRateEnabled() {
        return this.isDataRateEnabled;
    }

    public void setDataBitRateEnabled(boolean enabled) {
        this.isDataRateEnabled = enabled;
    }
}

