/*
 * Decompiled with CFR 0.152.
 */
package unified.bootloader16bit.phy.lin;

import java.nio.ByteBuffer;
import java.util.Optional;
import unified.bootloader16bit.phy.lin.InvalidPduException;
import unified.bootloader16bit.phy.lin.Pdu;

public class PduConsecutiveFrame
implements Pdu {
    public static final int MAX_DATA = 6;
    private static final int PCI_INDEX = 1;
    private static final int DATA_START_INDEX = 2;
    public static final int MAX_SEQUENCE_NUMBER = 15;
    public static final int INITIAL_SEQUENCE_NUMBER = 1;
    private final byte nodeAddress;
    private final int sequenceNumber;
    private final byte[] data;

    private PduConsecutiveFrame(byte nodeAddress, int sequenceNumber, byte[] data) {
        this.nodeAddress = nodeAddress;
        this.sequenceNumber = sequenceNumber;
        this.data = data;
    }

    public static PduConsecutiveFrame create(byte[] frame) throws InvalidPduException {
        PduConsecutiveFrame.validateFrameLength(frame.length);
        PduConsecutiveFrame.validateFrameType(Pdu.Type.get(frame));
        byte[] data = new byte[6];
        System.arraycopy(frame, 2, data, 0, 6);
        return new PduConsecutiveFrame(Pdu.getNodeAddress(frame), PduConsecutiveFrame.getFrameCounterFromPci(frame[1]), data);
    }

    public static PduConsecutiveFrame create(byte nodeAddress, int sequenceNumber, ByteBuffer dataBuffer) {
        byte[] data = new byte[]{-1, -1, -1, -1, -1, -1};
        dataBuffer.get(data, 0, Math.min(dataBuffer.remaining(), 6));
        return new PduConsecutiveFrame(nodeAddress, sequenceNumber, data);
    }

    private static void validateFrameLength(int length) throws InvalidPduException {
        if (length != 8) {
            throw new InvalidPduException("Invalid frame length: " + length);
        }
    }

    private static void validateFrameType(Pdu.Type type) throws InvalidPduException {
        if (!type.equals((Object)Pdu.Type.CONSECUTIVE_FRAME)) {
            throw new InvalidPduException("Invalid frame type: " + (Object)((Object)type));
        }
    }

    private static int getFrameCounterFromPci(byte pci) {
        return pci & 0xF;
    }

    public static int getNextSequenceNumber(int currentSequenceNumber) {
        if (currentSequenceNumber >= 15) {
            return 0;
        }
        if (currentSequenceNumber < 0) {
            return 1;
        }
        return currentSequenceNumber + 1;
    }

    @Override
    public byte[] get() {
        byte protocolControlInformation = (byte)(0x20 | this.sequenceNumber);
        byte[] frame = new byte[]{this.nodeAddress, protocolControlInformation, -1, -1, -1, -1, -1, -1};
        System.arraycopy(this.data, 0, frame, 2, this.data.length);
        return frame;
    }

    @Override
    public byte getNodeAddress() {
        return this.nodeAddress;
    }

    @Override
    public Pdu.Type getType() {
        return Pdu.Type.CONSECUTIVE_FRAME;
    }

    @Override
    public byte[] getData() {
        return this.data;
    }

    @Override
    public Optional<Integer> getLength() {
        return Optional.empty();
    }

    @Override
    public Optional<Byte> getServiceId() {
        return Optional.empty();
    }

    @Override
    public Optional<Integer> getSequenceNumber() {
        return Optional.of(this.sequenceNumber);
    }
}

