/*
 * Decompiled with CFR 0.152.
 */
package unified.bootloader16bit.phy.lin;

import java.util.Optional;
import unified.bootloader16bit.phy.lin.InvalidPduException;
import unified.bootloader16bit.phy.lin.Pdu;
import unified.bootloader16bit.phy.lin.PduConsecutiveFrame;
import unified.bootloader16bit.phy.lin.PduFirstFrame;
import unified.bootloader16bit.phy.lin.PduSingleFrame;

class PduFactory {
    private PduFactory() {
    }

    static Optional<Pdu> getPdu(byte[] frame) {
        try {
            switch (Pdu.Type.get(frame)) {
                case SINGLE_FRAME: {
                    return Optional.of(PduSingleFrame.create(frame));
                }
                case FIRST_FRAME: {
                    return Optional.of(PduFirstFrame.create(frame));
                }
                case CONSECUTIVE_FRAME: {
                    return Optional.of(PduConsecutiveFrame.create(frame));
                }
            }
            return Optional.empty();
        }
        catch (InvalidPduException e) {
            return Optional.empty();
        }
    }
}

