/*
 * Decompiled with CFR 0.152.
 */
package unified.bootloader16bit.phy.lin;

public class Pid {
    private Pid() {
    }

    public static byte getBit(byte source, int bitPosition) {
        return (byte)(source >>> bitPosition & 1);
    }

    public static byte get(byte p0, byte p1, byte frameId) {
        byte pid = frameId;
        pid = (byte)(pid | (byte)(p0 << 6));
        pid = (byte)(pid | (byte)(p1 << 7));
        return pid;
    }

    public static byte get(byte frameId) {
        byte id0 = Pid.getBit(frameId, 0);
        byte id1 = Pid.getBit(frameId, 1);
        byte id2 = Pid.getBit(frameId, 2);
        byte id3 = Pid.getBit(frameId, 3);
        byte id4 = Pid.getBit(frameId, 4);
        byte id5 = Pid.getBit(frameId, 5);
        byte p0 = (byte)(id0 ^ id1 ^ id2 ^ id4);
        byte p1 = (byte)(1 ^ (id1 ^ id3 ^ id4 ^ id5));
        return Pid.get(p0, p1, frameId);
    }
}

