/*
 * Decompiled with CFR 0.152.
 */
package unified.bootloader16bit.phy.lin.plin;

import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;

public enum TLINHardwareState {
    NOT_INITIALIZED(0),
    AUTO_BAUDRATE(1),
    ACTIVE(2),
    SLEEP(3),
    SHORT_GROUND(4),
    VBAT_MISSING(5),
    INVALID_CODE(-1);

    private static final Logger logger;
    private final int code;

    private TLINHardwareState(int code) {
        this.code = code;
    }

    public static TLINHardwareState get(int code) {
        TLINHardwareState stateReturn = Arrays.asList(TLINHardwareState.values()).stream().filter(state -> state.code == code).findFirst().orElse(INVALID_CODE);
        if (stateReturn.equals((Object)INVALID_CODE)) {
            logger.log(Level.SEVERE, "Invalid TLINHardwareState code provided: {0}", code);
        }
        return stateReturn;
    }

    static {
        logger = Logger.getLogger(TLINHardwareState.class.getName());
    }
}

