/*
 * Decompiled with CFR 0.152.
 */
package org.hid4java;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hid4java.HidDevice;
import org.hid4java.HidException;
import org.hid4java.event.HidServicesListenerList;
import org.hid4java.jna.HidApi;
import org.hid4java.jna.HidDeviceInfoStructure;

class HidDeviceManager {
    private int scanInterval = 500;
    private final Map<String, HidDevice> attachedDevices = Collections.synchronizedMap(new HashMap());
    private final HidServicesListenerList listenerList;
    private Thread scanThread = null;
    private boolean scanning = false;

    HidDeviceManager(HidServicesListenerList listenerList, int scanInterval) throws HidException {
        this.listenerList = listenerList;
        this.scanInterval = scanInterval;
        try {
            HidApi.init();
        }
        catch (Throwable t) {
            throw new HidException("Hidapi did not initialise: " + t.getMessage());
        }
    }

    public void start() {
        if (this.isScanning()) {
            return;
        }
        this.scan();
        final int scanInterval = this.scanInterval;
        if (scanInterval == 0) {
            return;
        }
        this.scanThread = new Thread(new Runnable(){

            @Override
            public void run() {
                HidDeviceManager.this.scanning = true;
                while (true) {
                    try {
                        Thread.sleep(scanInterval);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        break;
                    }
                    HidDeviceManager.this.scan();
                }
                HidDeviceManager.this.scanning = false;
            }
        });
        this.scanThread.setDaemon(true);
        this.scanThread.setName("hid4java Device Scanner");
        this.scanThread.start();
    }

    public synchronized void stop() {
        if (this.scanThread != null) {
            this.scanThread.interrupt();
        }
    }

    public synchronized void scan() {
        ArrayList<String> removeList = new ArrayList<String>();
        List<HidDevice> attachedHidDeviceList = this.getAttachedHidDevices();
        for (HidDevice hidDevice : attachedHidDeviceList) {
            if (this.attachedDevices.containsKey(hidDevice.getId())) continue;
            this.attachedDevices.put(hidDevice.getId(), hidDevice);
            this.listenerList.fireHidDeviceAttached(hidDevice);
        }
        for (Map.Entry entry : this.attachedDevices.entrySet()) {
            String deviceId = (String)entry.getKey();
            HidDevice hidDevice = (HidDevice)entry.getValue();
            if (attachedHidDeviceList.contains(hidDevice)) continue;
            removeList.add(deviceId);
            this.listenerList.fireHidDeviceDetached(this.attachedDevices.get(deviceId));
        }
        if (!removeList.isEmpty()) {
            this.attachedDevices.keySet().removeAll(removeList);
        }
    }

    public void setScanInterval(int scanInterval) {
        this.scanInterval = scanInterval;
    }

    public boolean isScanning() {
        return this.scanning;
    }

    public List<HidDevice> getAttachedHidDevices() {
        HidDeviceInfoStructure root;
        ArrayList<HidDevice> hidDeviceList = new ArrayList<HidDevice>();
        try {
            root = HidApi.enumerateDevices(0, 0);
        }
        catch (Throwable e) {
            this.stop();
            throw new HidException("Unable to start HidApi: " + e.getMessage());
        }
        if (root != null) {
            HidDeviceInfoStructure hidDeviceInfoStructure = root;
            do {
                hidDeviceList.add(new HidDevice(hidDeviceInfoStructure));
            } while ((hidDeviceInfoStructure = hidDeviceInfoStructure.next()) != null);
            HidApi.freeEnumeration(root);
        }
        return hidDeviceList;
    }
}

