/*
 * Decompiled with CFR 0.152.
 */
package packetprocessor;

import exceptionclasses.ValidationException;
import i2cBootloaderModel.CommandModelPIC32;
import packetprocessor.IPacketProcessor;

public abstract class APacketProcessorMCU32
implements IPacketProcessor {
    protected byte command;
    protected byte[] lengthProcess;
    protected byte[] addressProcess;
    protected byte[] dataPayload;
    public final byte SOF = 1;
    public final byte EOT = (byte)4;
    public final byte COMMAND = (byte)3;
    public final byte DLE = (byte)16;
    public static final int CRC_INIT_VALUE = -1;
    public static final int CRC_XOR_VALUE = -306674912;

    protected abstract void pack(byte[] var1);

    @Override
    public void packPacket(Object whatModel, int timeOut) throws ValidationException {
        this.command = ((CommandModelPIC32)whatModel).command;
        this.dataPayload = ((CommandModelPIC32)whatModel).dataPayload;
        this.validatePacket();
        CommandModelPIC32 model = (CommandModelPIC32)whatModel;
        if (model.writeLength == 0 && (this.command == 3 || this.command == 4)) {
            int modifier = 5;
            byte[] crcCheckData = new byte[model.dataPayload.length + 1];
            crcCheckData[0] = this.command;
            int dleByte = 0;
            boolean dleSkipByte = false;
            for (int loopCount = 1; loopCount <= model.dataPayload.length; ++loopCount) {
                byte readByte = model.dataPayload[loopCount - 1];
                if (readByte == this.DLE && !dleSkipByte) {
                    ++dleByte;
                    dleSkipByte = true;
                    continue;
                }
                dleSkipByte = false;
                crcCheckData[loopCount - dleByte] = readByte;
            }
            long crcCheck = APacketProcessorMCU32.crc_Calculator(crcCheckData, crcCheckData.length - dleByte);
            if ((byte)crcCheck == this.SOF || (byte)crcCheck == this.EOT || (byte)crcCheck == this.COMMAND || (byte)crcCheck == this.DLE) {
                ++modifier;
            }
            if ((byte)(crcCheck >> 8) == this.SOF || (byte)(crcCheck >> 8) == this.EOT || (byte)(crcCheck >> 8) == this.COMMAND || (byte)(crcCheck >> 8) == this.DLE) {
                ++modifier;
            }
            model.data = new byte[model.dataPayload.length + modifier];
        }
        this.pack(((CommandModelPIC32)whatModel).data);
    }

    public void validatePacket() throws ValidationException {
    }

    public byte[] longTobyteArray(long data) {
        byte[] dataConverted = new byte[4];
        for (int i = 0; i < 4; ++i) {
            dataConverted[i] = (byte)data;
            data >>= 8;
        }
        return dataConverted;
    }

    public static long crc_Calculator(byte[] crcData, int length) {
        int[] crcTable = new int[]{0, 4129, 8258, 12387, 16516, 20645, 24774, 28903, 33032, 37161, 41290, 45419, 49548, 53677, 57806, 61935};
        int crcValue = 0;
        int byteNumber = 0;
        while (length-- != 0) {
            long tempValue = crcValue >>> 12 ^ crcData[byteNumber] >>> 4;
            crcValue = crcTable[(int)tempValue & 0xF] ^ crcValue << 4;
            tempValue = crcValue >>> 12 ^ crcData[byteNumber];
            crcValue = crcTable[(int)tempValue & 0xF] ^ crcValue << 4;
            ++byteNumber;
        }
        return crcValue & 0xFFFF;
    }

    public static long crc32_Calculator(byte[] crcData, int length) {
        int i;
        int[] crc_tab = new int[256];
        int size = length;
        int crc = -1;
        for (i = 0; i < 256; ++i) {
            int value = i;
            for (int j = 0; j < 8; ++j) {
                if ((value & 1) == 1) {
                    value = value >> 1 ^ 0xEDB88320;
                    continue;
                }
                value >>= 1;
            }
            crc_tab[i] = value;
        }
        for (i = 0; i < size; ++i) {
            crc = crc_tab[(crc ^ crcData[i]) & 0xFF] ^ crc >> 8;
        }
        return crc;
    }
}

