/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.client;

import com.azul.crs.client.Client;
import com.azul.crs.client.InterfaceConnectionManager;
import com.azul.crs.client.PerformanceMetrics;
import com.azul.crs.client.Response;
import com.azul.crs.client.Utils;
import com.azul.crs.client.models.Payload;
import com.azul.crs.client.models.VMArtifactChunk;
import com.azul.crs.client.models.VMEvent;
import com.azul.crs.client.service.DataWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;

public class DummyConnectionManager
implements InterfaceConnectionManager {
    private static final String VM_EVENTS_OUTPUT_NAME = "VM_EVENTS_";
    private static final String VM_ARTIFACTS_OUTPUT_NAME = "VM_ARTIFACT_DATA_";
    private final String vmId;
    private final String mailbox;
    private final String restAPI;
    private final InterfaceConnectionManager.ConnectionListener listener;
    private PrintWriter vmEventsOutput;
    private PrintWriter vmArtifactChunksOutput;

    public DummyConnectionManager(Map<Client.ClientProp, Object> map, InterfaceConnectionManager.ConnectionListener connectionListener) {
        this.listener = connectionListener;
        this.vmId = UUID.randomUUID().toString();
        this.restAPI = (String)map.get((Object)Client.ClientProp.API_URL);
        this.mailbox = (String)map.get((Object)Client.ClientProp.API_MAILBOX);
    }

    @Override
    public Response<String[]> sendVMEventBatch(Collection<VMEvent> collection) throws IOException {
        Iterator<Payload.DataWithCounters> iterator = VMEvent.toJsonArrays(collection, 0x200000);
        while (iterator.hasNext()) {
            Payload.DataWithCounters dataWithCounters = iterator.next();
            String string = dataWithCounters.data;
            this.vmEventsOutput.println(string);
            PerformanceMetrics.logEventBatch(collection.size());
            dataWithCounters.counters.forEach((type, l) -> {
                switch (type) {
                    case VM_CLASS_LOADED: {
                        PerformanceMetrics.logClassLoads(l);
                        break;
                    }
                    case VM_JAR_LOADED: {
                        PerformanceMetrics.logJarLoads(l);
                        break;
                    }
                    case VM_METHOD_FIRST_CALLED: {
                        PerformanceMetrics.logMethodEntries(l);
                    }
                }
            });
        }
        return null;
    }

    @Override
    public boolean requestWithRetries(InterfaceConnectionManager.ResponseSupplier responseSupplier, String string, int n, long l) {
        try {
            responseSupplier.get();
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    @Override
    public Response<String[]> sendVMArtifactChunk(VMArtifactChunk vMArtifactChunk, DataWriter dataWriter) throws IOException {
        Object object;
        this.vmArtifactChunksOutput.println(vMArtifactChunk.toJson());
        if (dataWriter != null) {
            object = new ByteArrayOutputStream();
            dataWriter.writeData((OutputStream)object);
            this.vmArtifactChunksOutput.println(((ByteArrayOutputStream)object).toString());
        }
        object = new Response();
        ((Response)object).code(200);
        return object;
    }

    @Override
    public String getVmId() {
        return this.vmId;
    }

    @Override
    public String getMailbox() {
        return this.mailbox;
    }

    @Override
    public String getRestAPI() {
        return this.restAPI;
    }

    @Override
    public void start() throws IOException {
        String string = System.getProperty("java.io.tmpdir");
        Path path = Paths.get(string, VM_EVENTS_OUTPUT_NAME + this.vmId + ".log");
        this.vmEventsOutput = new PrintWriter(Files.newBufferedWriter(path, new OpenOption[0]));
        Path path2 = Paths.get(string, VM_ARTIFACTS_OUTPUT_NAME + this.vmId + ".log");
        this.vmArtifactChunksOutput = new PrintWriter(Files.newBufferedWriter(path2, new OpenOption[0]));
        this.listener.authenticated();
    }

    @Override
    public void stop(Utils.Deadline deadline) {
        this.vmEventsOutput.flush();
        this.vmEventsOutput.close();
        this.vmArtifactChunksOutput.flush();
        this.vmArtifactChunksOutput.close();
    }
}

