/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.client.jars;

import com.azul.crs.client.JDKAccessor;
import com.azul.crs.client.Tweaks;
import com.azul.crs.client.Utils;
import com.azul.crs.client.jars.JarSource;
import com.azul.crs.client.jars.VMEventHelper;
import com.azul.crs.client.models.VMEvent;
import com.azul.crs.client.util.JarAccessUtils;
import com.azul.crs.client.util.ThrowingConsumer;
import com.azul.crs.jar.ZipTools;
import com.azul.crs.runtime.utils.ClassMethodsMap;
import com.azul.crs.runtime.utils.DataEntriesMap;
import com.azul.crs.runtime.utils.TempFilesFactory;
import com.azul.crs.util.logging.Logger;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collectors;

public class JarAccess {
    final Logger logger = Logger.getLogger(this.getClass());
    private final String source;
    private InitiatedBy initiatedBy;
    private final JarAccessUtils jarAccessUtils;
    private String hash;
    private ZipTools.JarShortDigest jarShortDigest;
    private JarEntry jarEntry;
    private final JarFile originJar;
    private final URL url;
    private String path;
    private JarFile actualJar;
    private JarAccess parent;
    Cache cache;
    private TempFilesFactory.TempFile tempFile;

    public TempFilesFactory.TempFile getTempFile() {
        return this.tempFile;
    }

    public JarAccess(JarAccessUtils jarAccessUtils, JarFile jarFile, JarSource jarSource, String string, InitiatedBy initiatedBy) {
        this(jarAccessUtils, null, jarFile, jarSource.getUrl(), string, jarSource.getUrl().toString(), initiatedBy, null);
    }

    public JarAccess(JarAccessUtils jarAccessUtils, JarAccess jarAccess, JarFile jarFile, URL uRL, String string, String string2, InitiatedBy initiatedBy, JarEntry jarEntry) {
        this.jarAccessUtils = jarAccessUtils;
        this.originJar = jarFile;
        this.url = uRL;
        this.actualJar = jarFile;
        this.path = string;
        this.source = string2;
        this.initiatedBy = initiatedBy;
        this.parent = jarAccess;
        this.jarEntry = jarEntry;
    }

    public void setInitiatedBy(InitiatedBy initiatedBy) {
        this.initiatedBy = initiatedBy;
    }

    public JarFile getJarFile() {
        return this.actualJar;
    }

    EntryAccess entryAccess() {
        if (this.jarEntry == null) {
            return null;
        }
        return new EntryAccess();
    }

    public void withInputStream(ThrowingConsumer<InputStream, Exception> throwingConsumer) {
        if (this.entryAccess() != null) {
            this.entryAccess().withInputStream(throwingConsumer);
        } else {
            try {
                this.doWithJarReopen(jarAccess -> throwingConsumer.accept(null));
            }
            catch (Exception exception) {
                throw new RuntimeException("wrap:", exception);
            }
        }
    }

    public Long requiredTempfsSpace() {
        return this.jarEntry == null ? 0L : this.entryAccess().getSize();
    }

    public String getManifesthash() {
        return this.jarShortDigest == null ? null : Utils.encodeToStringOrNull(this.jarShortDigest.getManifestHash());
    }

    public ZipTools.JarShortDigest getJarShortDigest() {
        if (this.jarShortDigest != null) {
            return this.jarShortDigest;
        }
        try {
            this.jarShortDigest = this.jarAccessUtils.calculateJarShortDigest(this);
        }
        catch (Exception exception) {
            this.logger.error("Failed to calculate jarShortDigset for (%s) with exception: %s", this, exception);
        }
        return this.jarShortDigest;
    }

    public JarAccess getParentJarAccess() {
        return this.parent;
    }

    public String getJarName() {
        return this.tempFile != null ? this.tempFile.getPath() : this.getUnifiedPath();
    }

    public String getUnifiedPath() {
        return !this.getPath().contains("!/") ? this.getPath() : "jar:file:" + this.getPath() + "!/";
    }

    public Cache getCache() {
        if (this.cache == null) {
            this.cache = new Cache();
        }
        return this.cache;
    }

    public void acquireResources(TempFilesFactory.TempFile tempFile) throws IOException {
        this.getCache();
        this.tempFile = tempFile;
        if (this.jarEntry != null) {
            this.path = tempFile.getAbsolutePath();
            this.withInputStream(inputStream -> Files.copy(inputStream, tempFile.toPath(), StandardCopyOption.REPLACE_EXISTING));
            this.actualJar = new JarFile((File)tempFile, false);
        }
    }

    public void releaseResources() {
        if (this.actualJar != this.originJar) {
            try {
                this.actualJar.close();
            }
            catch (IOException iOException) {
                throw new RuntimeException("wrap:", iOException);
            }
        }
        if (this.tempFile != null) {
            this.tempFile.delete();
        }
        this.cache = null;
    }

    public String getPath() {
        return this.path;
    }

    public String getHashLazy() {
        return this.hash;
    }

    public String getHash() throws CentralDirectoryHashNotInitializedException {
        if (this.hash != null) {
            return this.hash;
        }
        this.doWithJarReopen(jarAccess -> {
            if (jarAccess == null || jarAccess.getJarShortDigest() == null) {
                throw new CentralDirectoryHashNotInitializedException("unexpected request: jarAccess=" + jarAccess + ", digest=" + (jarAccess != null ? jarAccess.getJarShortDigest() : null));
            }
            this.hash = Utils.encodeToStringOrNull(jarAccess.getJarShortDigest().getCentralDirectoryHash());
        });
        if (this.hash != null) {
            return this.hash;
        }
        throw new CentralDirectoryHashNotInitializedException("central directory hash not initialized yet.");
    }

    public URL getURL() {
        return this.url;
    }

    public String getSource() {
        return this.source;
    }

    public String getUrlOrSourceOrNull() {
        if (this.url != null) {
            return this.url.toString();
        }
        if (this.source != null) {
            return this.source.toString();
        }
        return null;
    }

    public void forEachJarEntry(ThrowingConsumer<JarAccess, Exception> throwingConsumer) {
        this.doWithJarReopen(jarAccess -> {
            for (JarEntry jarEntry : Collections.list(jarAccess.getJarFile().entries())) {
                if (!ZipTools.isJarFile(jarEntry.getName())) continue;
                JarAccess jarAccess2 = new JarAccess(this.jarAccessUtils, this, null, null, this.path + "!/" + jarEntry.getName(), this.source + jarEntry.getName() + "!/", InitiatedBy.RECURSIVE_LOADING, jarEntry);
                throwingConsumer.accept(jarAccess2);
            }
        });
    }

    public void forEachEntry(ThrowingConsumer<EntryAccess, Exception> throwingConsumer) {
        this.doWithJarReopen(jarAccess -> {
            for (JarEntry jarEntry : Collections.list(jarAccess.getJarFile().entries())) {
                if (jarEntry.isDirectory()) continue;
                JarAccess jarAccess2 = new JarAccess(this.jarAccessUtils, this, null, null, this.path + "!/" + jarEntry.getName(), this.source + jarEntry.getName() + "!/", InitiatedBy.RECURSIVE_LOADING, jarEntry);
                throwingConsumer.accept(jarAccess2.entryAccess());
            }
        });
    }

    public void forEachManifestClassPathEntry(ThrowingConsumer<String, Exception> throwingConsumer) {
        this.doWithJarReopen(jarAccess -> {
            File file = new File(jarAccess.getJarFile().getName());
            File file2 = file.getParentFile();
            String string = file2 != null ? file2.getAbsolutePath() + File.separator : "";
            for (String string3 : this.getJarLocalClassPath(this.getJarFile()).stream().map(string2 -> string + string2).collect(Collectors.toList())) {
                throwingConsumer.accept(string3);
            }
        });
    }

    public InitiatedBy getInitiatedBy() {
        return this.initiatedBy;
    }

    public int getNestingLevel() {
        int n = 0;
        for (JarAccess jarAccess = this.parent; n < 99 && jarAccess != null; ++n, jarAccess = jarAccess.getParentJarAccess()) {
        }
        return n;
    }

    public long requiredTempfsSpaceWithParents() {
        return this.requiredTempfsSpace() + (this.parent != null ? this.parent.requiredTempfsSpaceWithParents() : 0L);
    }

    public boolean equals(Object object) {
        if (object instanceof JarAccess) {
            return Objects.equals(this.getPath(), ((JarAccess)object).getPath()) && Objects.equals(this.getURL(), ((JarAccess)object).getURL()) && Objects.equals(this.getSource(), ((JarAccess)object).getSource());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode(this.getPath()) ^ Objects.hashCode(this.getURL()) ^ Objects.hashCode(this.getSource());
    }

    private void reopenJar() throws IOException {
        this.logger.trace("reopening jar: %s; by file name: %s", this, this.getJarFile().getName());
        this.actualJar = new JarFile(this.getJarFile().getName(), false);
    }

    private void doWithJarReopen(ThrowingConsumer<JarAccess, Exception> throwingConsumer) {
        try {
            int n = 0;
            while (true) {
                ++n;
                try {
                    throwingConsumer.accept(this);
                }
                catch (Exception exception) {
                    if (!(exception instanceof IOException || exception instanceof JDKAccessor.ZipFileInconsistentException || ZipTools.ZipFileClosedException.isZipFileClosedException(exception))) {
                        throw exception;
                    }
                    this.reopenJar();
                    if (n < 3) continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            this.logger.debug("doWithJarReopen failed for url=%s with exception=%s", this.getURL(), exception);
            throw new RuntimeException("Wrapper:", exception);
        }
    }

    private Collection<String> getJarManifestAttributeAsList(JarFile jarFile, String string) {
        try {
            if (jarFile == null) {
                return Collections.emptyList();
            }
            if (jarFile.getManifest() == null) {
                return Collections.emptyList();
            }
            if (jarFile.getManifest().getMainAttributes() == null) {
                return Collections.emptyList();
            }
            if (jarFile.getManifest().getMainAttributes().getValue(string) == null) {
                return Collections.emptyList();
            }
            return Arrays.asList(jarFile.getManifest().getMainAttributes().getValue(string).split("[ :]"));
        }
        catch (Exception exception) {
            this.logger.debug("Failed to get manifest attributes %s from jar %s due to exception: %s", string, com.azul.crs.client.util.Utils.toStringWithIdentityHash(jarFile), exception);
            return Collections.emptyList();
        }
    }

    private Collection<String> getJarLocalClassPath(JarFile jarFile) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(this.getJarManifestAttributeAsList(jarFile, "Class-Path"));
        arrayList.addAll(this.getJarManifestAttributeAsList(jarFile, "Boot-Class-Path"));
        return arrayList;
    }

    public String toString() {
        return "JarAccess[parent=" + Objects.toString(this.parent) + ", url=" + this.url + ", originJar=" + this.originJar + ":" + (this.originJar == null ? null : this.originJar.getName()) + ", actualJar=" + this.actualJar + ":" + (this.actualJar == null ? null : this.actualJar.getName()) + ", className=" + (this.originJar == null ? null : this.originJar.getClass().getName()) + ", path=" + this.path + ", source=" + this.source + ", hash=" + this.hash + ", sizeRequired=" + this.requiredTempfsSpace() + ", cache=" + Objects.toString(this.cache) + "]";
    }

    private static Logger logger() {
        return Logger.getLogger(JarAccess.class);
    }

    private class CentralDirectoryHashNotInitializedException
    extends RuntimeException {
        public CentralDirectoryHashNotInitializedException(String string) {
            super(string);
        }
    }

    public static class Cache {
        public VMEvent vmEvent;
        public DataEntriesMap<VMEventHelper.Hashes> entriesMap;
        public ClassMethodsMap classMethodsMap = new ClassMethodsMap();
        public DebugInfo lastDebugInfo = DebugInfo.NONE;
        public List<String> debugInfoList = new ArrayList<String>();

        public void addDebugInfo(DebugInfo debugInfo, String string) {
            if (!Tweaks.DEBUG_JARLOAD) {
                return;
            }
            this.lastDebugInfo = debugInfo;
            this.debugInfoList.add(Objects.toString((Object)debugInfo) + ":" + string);
        }

        public void addDebugInfo(DebugInfo debugInfo) {
            if (!Tweaks.DEBUG_JARLOAD) {
                return;
            }
            this.lastDebugInfo = debugInfo;
            this.debugInfoList.add(Objects.toString((Object)debugInfo));
        }

        private String printEventDetails() {
            if (this.vmEvent == null) {
                return "null";
            }
            if (this.vmEvent.getEventPayload() == null) {
                return "<no-payload>";
            }
            if (!(this.vmEvent.getEventPayload() instanceof Map)) {
                return "<type:" + this.vmEvent.getEventPayload().getClass().getName() + ">";
            }
            Map map = (Map)this.vmEvent.getEventPayload();
            return "[extractionMethod=" + map.get("centralDirectoryExtractionMethod") + ", depth=" + map.get("recursionDepth") + "]";
        }

        public String toString() {
            return "Cache[entries=" + (this.entriesMap == null ? null : Integer.valueOf(this.entriesMap.size())) + ", debug=[" + (Object)((Object)this.lastDebugInfo) + "; " + this.debugInfoList.stream().collect(Collectors.joining(", ")) + "], vmevent/details=" + this.printEventDetails() + "]";
        }

        public static enum DebugInfo {
            NONE,
            BEFORE_TEMP_ALLOCATION,
            ON_TEMP_ALLOCATION_CALLBACK,
            ON_NOT_ENOUGH_TEMPFS_LIMIT,
            TEMPFILE_ALLOCATED,
            TEMPFILE_IS_DELETING,
            TEMPFILE_IS_NOT_REQUIRED,
            BEFORE_REPORT_MINIMAL_EVENT,
            MINIMAL_EVENT_FINALIZER,
            MINIMAL_EVENT_ON_COUNTDOWN,
            MINIMAL_EVENT_SENT_SUCCESSFULLY,
            MINIMAL_EVENT_WAS_NOT_SENT_DUE_TO_ERROR,
            JAR_DETAILS_RECEIVED,
            JAR_DETAILS_NONE,
            JAR_DETAILS_ALL_HASHES,
            BEFORE_REPORTING_NESTED,
            ALL_NESTED_REPORTED,
            NESTED_JAR_REPORTING_ERROR,
            BEFORE_REPORT_FULL_EVENT,
            FULL_EVENT_SENT_SUCCESFULLY,
            FULL_EVENT_WAS_NOT_SENT_DUE_TO_ERROR,
            BEFORE_REPORT_CLASS_PATH_ATTRIBUTE;

        }
    }

    public class EntryAccess {
        public String getName() {
            return JarAccess.this.jarEntry.getName();
        }

        public long getCrc() {
            return JarAccess.this.jarEntry.getCrc();
        }

        public void withInputStream(ThrowingConsumer<InputStream, Exception> throwingConsumer) {
            JarEntry jarEntry = JarAccess.this.jarEntry;
            JarAccess.this.parent.doWithJarReopen(jarAccess -> throwingConsumer.accept(jarAccess.getJarFile().getInputStream(jarEntry)));
        }

        public long getSize() {
            return JarAccess.this.jarEntry.getSize();
        }
    }

    public static enum InitiatedBy {
        CLASS_LOADING,
        JDK_NATIVE_LOADING,
        RECURSIVE_LOADING,
        SERVER_REQUEST,
        CLASS_PATH_ENTRY,
        CLASS_PATH_ENTRY_BY_MANIFEST,
        OTHER;

    }
}

