/*
 * Decompiled with CFR 0.152.
 */
package purejavacomm.example;

import java.io.InputStream;
import java.io.OutputStream;
import jtermios.JTermios;
import jtermios.Termios;
import purejavacomm.CommPortIdentifier;
import purejavacomm.PureJavaSerialPort;
import purejavacomm.SerialPort;

public class Example1 {
    public void sample() {
        int n;
        Object port = null;
        int FD = ((PureJavaSerialPort)port).getNativeFileDescriptor();
        int messageLength = 25;
        int timeout = 200;
        byte[] readBuffer = new byte[messageLength];
        Termios termios2 = new Termios();
        if (0 != JTermios.tcgetattr(FD, termios2)) {
            this.errorHandling();
        }
        termios2.c_cc[JTermios.VTIME] = (byte)(timeout / 100);
        termios2.c_cc[JTermios.VMIN] = (byte)messageLength;
        if (0 != JTermios.tcsetattr(FD, JTermios.TCSANOW, termios2)) {
            this.errorHandling();
        }
        if ((n = JTermios.read(FD, readBuffer, messageLength)) < 0) {
            this.errorHandling();
        }
    }

    public void errorHandling() {
    }

    public static void main(String[] args) {
        try {
            int received;
            String portName = "tty.usbserial-FTOXM3NX";
            CommPortIdentifier portId = CommPortIdentifier.getPortIdentifier(portName);
            SerialPort port = (SerialPort)portId.open("Example1", 1000);
            OutputStream outStream = port.getOutputStream();
            InputStream inStream = port.getInputStream();
            byte[] dataToSend = new byte[]{17, 34, 51, 68, 85};
            outStream.write(dataToSend, 0, dataToSend.length);
            int messageLength = 5;
            byte[] dataReceived = new byte[messageLength];
            for (received = 0; received < messageLength; received += inStream.read(dataReceived, received, messageLength - received)) {
            }
            for (int i = 0; i < received; ++i) {
                if (dataReceived[i] == dataToSend[i]) continue;
                System.err.println("error at " + i + "th byte, sent " + dataToSend[i] + " received " + dataReceived);
            }
            System.out.println("Done");
            port.close();
        }
        catch (Throwable thwble) {
            thwble.printStackTrace();
        }
    }
}

