/*
 * Decompiled with CFR 0.152.
 */
package com.microchip.core.util;

import com.microchip.core.util.AValidator;
import com.microchip.core.util.IValidatorComparator;
import java.math.BigInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HexOnlyValidator
extends AValidator
implements IValidatorComparator {
    private static final String HEX_REGEX = "0x([\\da-f,A-F]+)";
    private static final Pattern hexPattern = Pattern.compile("^\\s*0x([\\da-f,A-F]+)\\s*$");
    private Units setUnits;
    private Units currentUnits = Units.HEX;
    private int caretPosition = -1;
    private Integer maxBitCount = 32;
    private Integer minBitCount = 0;
    private static final Logger LOGGER = Logger.getLogger(HexOnlyValidator.class.getName());

    public HexOnlyValidator() {
    }

    public HexOnlyValidator(Integer validBitSize) {
        this.maxBitCount = validBitSize;
    }

    public HexOnlyValidator(String validBitSize) {
        if (validBitSize != null) {
            try {
                this.maxBitCount = Integer.parseInt(validBitSize);
            }
            catch (NumberFormatException ex) {
                this.maxBitCount = 32;
                LOGGER.log(Level.SEVERE, "Max Bit Count Bad. Use value of 32." + ex.toString(), ex);
                throw new NumberFormatException("Max Bit Count Bad. Use value of 32." + ex);
            }
        }
    }

    @Override
    public String validate(String input) {
        Matcher hexMatcher = hexPattern.matcher(input = input.toLowerCase());
        if (hexMatcher.matches()) {
            this.currentUnits = Units.HEX;
            BigInteger integer = new BigInteger(hexMatcher.group(1), 16);
            if (integer.bitLength() > this.maxBitCount || integer.bitLength() < this.minBitCount) {
                LOGGER.log(Level.FINE, String.format("Input more than " + this.maxBitCount + " :" + integer, new Object[0]));
                return null;
            }
            return "0x" + integer.toString(16).toUpperCase();
        }
        LOGGER.log(Level.FINE, String.format("Input was not an unsigned decimal or hexadecimal number: \"" + input + "\"", new Object[0]));
        return null;
    }

    @Override
    public String display(String value) {
        if (value == null) {
            return null;
        }
        String displayString = "";
        Matcher hexMatcher = hexPattern.matcher(value);
        if (hexMatcher.matches()) {
            this.currentUnits = Units.HEX;
            try {
                BigInteger integer = new BigInteger(hexMatcher.group(1), 16);
                displayString = "0x" + integer.toString(16).toUpperCase();
            }
            catch (NumberFormatException ex) {
                displayString = value;
                LOGGER.log(Level.SEVERE, String.format("Invalid Value (" + value + ") used for hexadecimal field." + ex, new Object[0]));
                throw new NumberFormatException("Invalid Value (" + value + ") used for hexadecimal field." + ex);
            }
            this.caretPosition = displayString.length();
        }
        return displayString;
    }

    @Override
    public int positionCaret() {
        return this.caretPosition;
    }

    @Override
    public Integer compareTo(String s1, String s2) {
        String n1 = this.validate(s1);
        String n2 = this.validate(s2);
        if (n1 == null) {
            return null;
        }
        if (n2 == null) {
            return null;
        }
        BigInteger d1 = new BigInteger(n1);
        BigInteger d2 = new BigInteger(n2);
        return d1.compareTo(d2);
    }

    public void setUnits(Units units) {
        this.setUnits = units;
    }

    public void setMaxBitCount(int bitCount) {
        this.maxBitCount = bitCount;
    }

    public void setMinBitCount(int bitCount) {
        this.minBitCount = bitCount;
    }

    public static enum Units {
        DECIMAL,
        HEX;

    }
}

