/*
 * Decompiled with CFR 0.152.
 */
package com.microchip.core.util;

import com.microchip.core.util.AValidator;
import com.microchip.core.util.IValidatorComparator;
import java.math.BigInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HexValidator
extends AValidator
implements IValidatorComparator {
    protected static final String HEX_REGEX = "0x([\\da-f,A-F]+)";
    protected static final String DECIMAL_REGEX = "[+-]?(\\d+)";
    protected static final Pattern hexPattern = Pattern.compile("^\\s*0x([\\da-f,A-F]+)\\s*$");
    protected static final Pattern decimalPattern = Pattern.compile("^\\s*([+-]?(\\d+))\\s*$");
    protected Units setUnits;
    protected Units currentUnits = Units.HEX;
    protected int caretPosition = -1;
    protected Integer validBitCount = 2;
    private static final Logger LOGGER = Logger.getLogger(HexValidator.class.getName());

    public HexValidator() {
    }

    public HexValidator(Integer validBitSize) {
        this.validBitCount = validBitSize;
    }

    public HexValidator(String validBitSize) {
        if (validBitSize != null) {
            try {
                this.validBitCount = Integer.parseInt(validBitSize);
            }
            catch (NumberFormatException ex) {
                LOGGER.log(Level.SEVERE, String.format("Bit Count Bad. Use default value." + ex, new Object[0]));
                throw new NumberFormatException("Bit Count Bad. Use default value." + ex);
            }
        }
    }

    @Override
    public String validate(String input) {
        Matcher hexMatcher = hexPattern.matcher(input = input.toLowerCase());
        if (hexMatcher.matches()) {
            this.currentUnits = Units.HEX;
            BigInteger integer = new BigInteger(hexMatcher.group(1), 16);
            if (integer.bitLength() > this.validBitCount) {
                LOGGER.log(Level.FINE, String.format("Input " + integer + "has too many bits (" + this.validBitCount + "): " + integer.bitCount(), new Object[0]));
                return null;
            }
            return integer.toString();
        }
        Matcher decimalMatcher = decimalPattern.matcher(input);
        if (decimalMatcher.matches()) {
            this.currentUnits = Units.DECIMAL;
            BigInteger integer = new BigInteger(decimalMatcher.group(1));
            if (integer.bitLength() > this.validBitCount) {
                LOGGER.log(Level.FINE, String.format("Input " + integer + "has too many bits (" + this.validBitCount + "): " + integer.bitCount(), new Object[0]));
                return null;
            }
            return integer.toString();
        }
        LOGGER.log(Level.FINE, String.format("Input was not an unsigned decimal or hexadecimal number: \"" + input + "\"", new Object[0]));
        return null;
    }

    @Override
    public String display(String value) {
        String displayString;
        if (value == null) {
            return null;
        }
        if (this.setUnits != null) {
            this.currentUnits = this.setUnits;
        }
        try {
            switch (this.currentUnits) {
                case DECIMAL: {
                    BigInteger integer = new BigInteger(value);
                    displayString = integer.toString();
                    break;
                }
                case HEX: {
                    BigInteger integer = new BigInteger(value);
                    displayString = "0x" + integer.toString(16).toUpperCase();
                    break;
                }
                default: {
                    LOGGER.log(Level.FINE, String.format("Unexpected units: " + this.currentUnits.name(), new Object[0]));
                    displayString = value;
                    break;
                }
            }
        }
        catch (NumberFormatException ex) {
            String displayString2 = value;
            LOGGER.log(Level.SEVERE, String.format("Invalid Value (" + value + ") used for hexadecimal field." + ex, new Object[0]), ex);
            throw new NumberFormatException("Invalid Value (" + value + ") used for hexadecimal field." + ex);
        }
        this.caretPosition = displayString.length();
        return displayString;
    }

    @Override
    public int positionCaret() {
        return this.caretPosition;
    }

    @Override
    public Integer compareTo(String s1, String s2) {
        String n1 = this.validate(s1);
        String n2 = this.validate(s2);
        if (n1 == null) {
            return null;
        }
        if (n2 == null) {
            return null;
        }
        BigInteger d1 = new BigInteger(n1);
        BigInteger d2 = new BigInteger(n2);
        return d1.compareTo(d2);
    }

    public void setUnits(Units units) {
        this.setUnits = units;
    }

    public void setValidCount(Integer bitSize) {
        this.validBitCount = bitSize;
    }

    public static enum Units {
        DECIMAL,
        HEX;

    }
}

