/*
 * Decompiled with CFR 0.152.
 */
package com.microchip.core.util;

import com.microchip.core.util.HexValidator;
import java.math.BigInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;

public class NumericalValidator
extends HexValidator {
    private static final Logger LOGGER = Logger.getLogger(NumericalValidator.class.getName());

    @Override
    public String validate(String input) {
        Matcher hexMatcher = hexPattern.matcher(input = input.toLowerCase());
        if (hexMatcher.matches()) {
            this.currentUnits = HexValidator.Units.HEX;
            BigInteger integer = new BigInteger(hexMatcher.group(1), 16);
            if (integer.intValue() > this.validBitCount) {
                LOGGER.log(Level.FINE, String.format("Input " + integer + "has too many bits (" + this.validBitCount + "): " + integer.bitCount(), new Object[0]));
                return null;
            }
            return integer.toString();
        }
        Matcher decimalMatcher = decimalPattern.matcher(input);
        if (decimalMatcher.matches()) {
            this.currentUnits = HexValidator.Units.DECIMAL;
            BigInteger integer = new BigInteger(decimalMatcher.group(1));
            if (integer.intValue() > this.validBitCount) {
                LOGGER.log(Level.FINE, String.format("Input " + integer + "has too many bits (" + this.validBitCount + "): " + integer.bitCount(), new Object[0]));
                return null;
            }
            return integer.toString();
        }
        LOGGER.log(Level.FINE, String.format("Input was not an unsigned decimal or hexadecimal number: \"" + input + "\"", new Object[0]));
        return null;
    }
}

