/*
 * Decompiled with CFR 0.152.
 */
package toplevel;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Application;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.image.Image;
import javafx.stage.Stage;
import toplevel.TopLevelFXMLController;
import unified.MVController.IMVController;
import unified.MVController.MVController;

public class TopLevel
extends Application {
    private static final Logger LOGGER = Logger.getLogger(TopLevel.class.getName());
    protected IMVController mvcController = new MVController();
    private static final String TITLE = "Unified Bootloader Host Application";
    private static Parent root = null;
    private String fileName = null;
    private Stage stage;

    public void start(Stage stage) throws Exception {
        Parent rootScene;
        root = rootScene = this.loadFxmlMainForm("TopLevelFXML.fxml");
        Scene scene = new Scene(rootScene);
        stage.getIcons().add((Object)new Image(((Object)((Object)this)).getClass().getResource("memory.png").toExternalForm()));
        stage.setScene(scene);
        stage.setTitle("Unified Bootloader Host Application " + TopLevel.getVersion());
        this.stage = stage;
        this.resizeStageToScene();
        stage.setOnCloseRequest(t -> this.exit());
        stage.show();
    }

    public static String getVersion() {
        try {
            Properties prop = new Properties();
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            InputStream stream = loader.getResourceAsStream("version.properties");
            prop.load(stream);
            return "v" + prop.getProperty("project.version", "");
        }
        catch (Exception ex) {
            LOGGER.log(Level.INFO, "Version properties file not found" + ex.toString(), ex);
            return "";
        }
    }

    private Parent loadFxmlMainForm(String file) throws IOException {
        TopLevelFXMLController form = new TopLevelFXMLController(this);
        URL location = ((Object)((Object)this)).getClass().getResource(file);
        FXMLLoader loader = new FXMLLoader(location);
        loader.setController((Object)form);
        Object result = loader.load();
        return (Parent)result;
    }

    public static void main(String[] args) {
        TopLevel.launch((String[])args);
    }

    private void exit() {
        System.exit(0);
    }

    public synchronized void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public synchronized String getFileName() {
        return this.fileName;
    }

    public void resizeStageToScene() {
        this.stage.sizeToScene();
    }

    public static String getTitle() {
        return TITLE;
    }

    public Parent getRoot() {
        return root;
    }
}

