/*
 * Decompiled with CFR 0.152.
 */
package toplevel;

import console.Console;
import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.ResourceBundle;
import java.util.prefs.Preferences;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Alert;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.layout.Pane;
import javafx.stage.FileChooser;
import toplevel.TopLevel;
import toplevel.TopLevelArchictecure;
import unified.bootloader16bit.Bootloader16TargetDevice;
import unified.bootloader32bit.UBoot32;
import unified.bootloader8bit.UBoot;
import unified.bootloaderAVR.UBootAVR;

public class TopLevelFXMLController
implements Initializable {
    private final TopLevel application;
    @FXML
    private ComboBox<String> deviceArchitectureOptions;
    @FXML
    private Pane attachingPane;
    @FXML
    private Label labelSelectedHex;
    @FXML
    private Menu menuFile;
    @FXML
    private MenuItem menuOpen;
    @FXML
    private MenuItem menuClose;
    @FXML
    private Menu menuSettings;
    @FXML
    private MenuItem menuSerial;
    @FXML
    private MenuItem menuUDP;
    @FXML
    private MenuItem menuUSB;
    @FXML
    private MenuItem menuI2C;
    @FXML
    private MenuItem menuCAN;
    @FXML
    private MenuItem menuLIN;
    @FXML
    private Menu menuTools;
    @FXML
    private MenuItem menuConsole;
    @FXML
    private Menu menuHelp;
    @FXML
    private MenuItem menuAbout;
    FileChooser fileOpenDialog = new FileChooser();
    Console consoleTopLevel = null;
    HashMap<String, TopLevelArchictecure> architectures = new HashMap();

    public TopLevelFXMLController(TopLevel application) {
        this.application = application;
    }

    public void initialize(URL url, ResourceBundle rb) {
        this.deviceArchitectureOptions.getSelectionModel().clearSelection();
        this.architectures = new HashMap();
        this.addNewArchitecture("PIC10\\PIC12\\PIC16\\PIC18 MCUs", new UBoot());
        this.addNewArchitecture("ATtiny\\ATmega\\AVR128D MCUs", new UBootAVR());
        this.addNewArchitecture("PIC24 MCUs \\ dsPIC33 DSCs", new Bootloader16TargetDevice());
        this.addNewArchitecture("PIC32MK\\PIC32MX\\PIC32MZ\\SAM MCUs", new UBoot32());
        this.enableProtocolSettingsOption("");
        this.deviceArchitectureOptions.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                if (!TopLevelFXMLController.this.attachingPane.getChildren().isEmpty()) {
                    TopLevelFXMLController.this.attachingPane.getChildren().remove(0);
                }
                TopLevelFXMLController.this.menuConsole.setDisable(TopLevelFXMLController.this.getTargetArchitecture() == null);
                TopLevelFXMLController.this.enableProtocolSettingsOption(TopLevelFXMLController.this.getTargetArchitecture().getProtocolType().get());
                TopLevelFXMLController.this.attachingPane.getChildren().add((Object)TopLevelFXMLController.this.getTargetArchitecture().getViewer());
                TopLevelFXMLController.this.getApplication().resizeStageToScene();
            }
        });
        this.architectures.forEach((name, architecture) -> architecture.getProtocolType().addListener((obs, oldValue, newValue) -> this.enableProtocolSettingsOption((String)newValue)));
    }

    @FXML
    void actionClose(ActionEvent event) {
        System.exit(0);
    }

    @FXML
    void actionAbout(ActionEvent event) {
        Alert alert = new Alert(Alert.AlertType.INFORMATION);
        alert.setTitle("About");
        alert.setHeaderText("Bootloader Build Information");
        alert.setContentText(TopLevel.getTitle() + " " + TopLevel.getVersion() + "\n For more information visit: http://microchip.com/bootloader\n");
        alert.showAndWait();
    }

    @FXML
    void actionOpenHex() {
        File initialDirectory = new File(Preferences.userNodeForPackage(this.getClass()).get("FilePath", System.getProperty("user.home")));
        if (Boolean.FALSE.equals(initialDirectory.isDirectory())) {
            initialDirectory = new File(System.getProperty("user.home"));
        }
        this.fileOpenDialog.setInitialDirectory(initialDirectory);
        this.fileOpenDialog.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter(".hex", new String[]{"*.hex"}));
        File fileChosen = this.fileOpenDialog.showOpenDialog(this.application.getRoot().getScene().getWindow());
        if (fileChosen != null) {
            this.labelSelectedHex.setText(fileChosen.getName() + " loaded");
            this.application.setFileName(fileChosen.getAbsolutePath());
            this.sendFileToAllArchitectures(fileChosen);
            Preferences.userNodeForPackage(this.getClass()).put("FilePath", fileChosen.getAbsolutePath().substring(0, fileChosen.getAbsolutePath().indexOf(fileChosen.getName())));
        }
    }

    private TopLevel getApplication() {
        return this.application;
    }

    private void enableProtocolSettingsOption(String protocol) {
        this.menuSerial.setDisable(!"UART".equals(protocol));
        this.menuUDP.setDisable(!"UDP".equals(protocol));
        this.menuUSB.setDisable(!"USB".equals(protocol));
        this.menuI2C.setDisable(!"I2C".equals(protocol));
        this.menuCAN.setDisable(!"CAN".equals(protocol));
        this.menuLIN.setDisable(!"LIN".equals(protocol));
    }

    @FXML
    void actionSettings() {
        this.getTargetArchitecture().showProtocolSettings();
    }

    @FXML
    void actionConsole() {
        this.getTargetArchitecture().showConsole();
    }

    private void sendFileToAllArchitectures(File file) {
        this.architectures.forEach((name, architecture) -> architecture.setHexFile(file));
    }

    private TopLevelArchictecure getTargetArchitecture() {
        return this.architectures.get(this.deviceArchitectureOptions.getValue());
    }

    private void addNewArchitecture(String description, TopLevelArchictecure architecture) {
        this.deviceArchitectureOptions.getItems().add((Object)description);
        this.architectures.put(description, architecture);
    }
}

