/*
 * Decompiled with CFR 0.152.
 */
package unified.bootloader16bit.phy.can;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.control.TitledPane;
import javafx.scene.paint.Paint;
import javafx.scene.text.Text;
import javafx.scene.text.TextFlow;
import javafx.stage.Stage;
import unified.bootloader16bit.Styles;
import unified.bootloader16bit.phy.Bitrate;
import unified.bootloader16bit.phy.can.MessageFormat;
import unified.bootloader16bit.phy.can.Model;

class Controller
implements Initializable {
    @FXML
    public ComboBox<String> comboCANModule;
    @FXML
    public Button buttonRefresh;
    @FXML
    public ComboBox<Bitrate> combonominalBitRate;
    @FXML
    public Label labelDataLength;
    @FXML
    public TextField tfmsgIDtoDevice;
    @FXML
    public TextField tfflowIDfromDevice;
    @FXML
    public CheckBox checkboxCanFd;
    @FXML
    public CheckBox checkboxDataRate;
    @FXML
    public ComboBox<Bitrate> comboDataBitRate;
    @FXML
    public Label labelDataRate;
    @FXML
    public TextFlow textflowIdFormatting;
    @FXML
    public TitledPane titledPanCanFd;
    @FXML
    public Label labelTxDL;
    @FXML
    public Button settingUpdate;
    @FXML
    public ComboBox<Integer> comboTxDL;
    @FXML
    public ComboBox<MessageFormat> comboboxMessageFormat;
    private final Text formatDescription = new Text("");
    private final Stage dialogStage;
    private final Model model;
    private SimpleObjectProperty<ObservableList<String>> comboCANModuleItems;
    private static final int CAN_CLASSIC_TXDL = 8;
    private final ArrayList<Text> idFormattingText;

    Controller(Stage stage, Model model) {
        this.dialogStage = stage;
        this.model = model;
        this.idFormattingText = new ArrayList<Text>(Arrays.asList(this.formatDescription));
        this.formatDescription.setText("Range: " + model.getMessageFormat().getRangeString());
    }

    @FXML
    public void actionApplySettings(ActionEvent actionEvent) {
        this.dialogStage.close();
        this.model.setCanFdEnabled(this.checkboxCanFd.isSelected());
        this.model.setDataBitRateEnabled(this.checkboxDataRate.isSelected());
        this.model.setTxDL((Integer)this.comboTxDL.getValue());
        this.model.setNominalBitRate(((Bitrate)this.combonominalBitRate.getSelectionModel().getSelectedItem()).getRate());
        this.model.setDataBitRate(((Bitrate)this.comboDataBitRate.getSelectionModel().getSelectedItem()).getRate());
        this.model.setPort((String)this.comboCANModule.getSelectionModel().selectedItemProperty().get());
        this.model.setHostToDeviceId((String)this.tfmsgIDtoDevice.textProperty().get());
        this.model.setDeviceToHostId((String)this.tfflowIDfromDevice.textProperty().get());
        this.model.setMessageFormat((MessageFormat)this.comboboxMessageFormat.getSelectionModel().getSelectedItem());
    }

    @FXML
    public void actionRefreshAnalyzerList(ActionEvent actionEvent) {
        ((ObservableList)this.comboCANModuleItems.get()).clear();
        ((ObservableList)this.comboCANModuleItems.get()).setAll(this.model.getPorts());
        this.comboCANModule.getSelectionModel().select((Object)this.model.getPort());
    }

    public void initialize(URL location, ResourceBundle resources) {
        SimpleObjectProperty nominalBitRateTimes = new SimpleObjectProperty((Object)FXCollections.observableArrayList());
        nominalBitRateTimes.bind((ObservableValue)this.combonominalBitRate.itemsProperty());
        ((ObservableList)nominalBitRateTimes.get()).setAll(this.getNominalBitRateOptions());
        this.combonominalBitRate.getSelectionModel().select(this.indexOfBitRate(this.getNominalBitRateOptions(), this.model.getNominalBitRate()));
        SimpleObjectProperty dataBitRateTimes = new SimpleObjectProperty((Object)FXCollections.observableArrayList());
        dataBitRateTimes.bind((ObservableValue)this.comboDataBitRate.itemsProperty());
        ((ObservableList)dataBitRateTimes.get()).setAll(this.getDataBitRateOptions());
        this.comboDataBitRate.getSelectionModel().select(this.indexOfBitRate(this.getDataBitRateOptions(), this.model.getDataBitRate()));
        SimpleObjectProperty txDL = new SimpleObjectProperty((Object)FXCollections.observableArrayList());
        txDL.bind((ObservableValue)this.comboTxDL.itemsProperty());
        ((ObservableList)txDL.get()).setAll(this.getTxDLOptions());
        this.checkboxCanFd.selectedProperty().set(this.model.isCanFdEnabled());
        this.checkboxDataRate.selectedProperty().set(this.model.isDataBitRateEnabled());
        this.comboTxDL.getSelectionModel().select((Object)this.model.getFDTxDL());
        this.tfmsgIDtoDevice.setText(this.model.getHostToDeviceId());
        this.tfflowIDfromDevice.setText(this.model.getDeviceToHostId());
        this.comboCANModuleItems = new SimpleObjectProperty((Object)FXCollections.observableArrayList());
        this.comboCANModuleItems.bind((ObservableValue)this.comboCANModule.itemsProperty());
        ((ObservableList)this.comboCANModuleItems.get()).setAll(this.model.getPorts());
        this.comboCANModule.getSelectionModel().select((Object)this.model.getPort());
        this.textflowIdFormatting.getChildren().addAll(this.idFormattingText);
        this.setIdFormattingColor((Paint)Styles.Text.VALID);
        this.tfmsgIDtoDevice.textProperty().addListener((observable, oldValue, newValue) -> this.validateFields());
        this.tfmsgIDtoDevice.focusedProperty().addListener((observable, oldValue, newValue) -> this.setHexPrefix(this.tfmsgIDtoDevice));
        this.tfflowIDfromDevice.textProperty().addListener((observable, oldValue, newValue) -> this.validateFields());
        this.tfflowIDfromDevice.focusedProperty().addListener((observable, oldValue, newValue) -> this.setHexPrefix(this.tfflowIDfromDevice));
        this.updateCanFdOptions();
        this.checkboxDataRate.selectedProperty().addListener((observable, oldValue, newValue) -> this.updateCanFdOptions());
        this.checkboxCanFd.selectedProperty().addListener((observable, oldValue, newValue) -> this.updateCanFdOptions());
        this.comboTxDL.getSelectionModel().selectedItemProperty().addListener((observable, oldValue, newValue) -> this.updateCanFdOptions());
        SimpleObjectProperty messageFormatOptions = new SimpleObjectProperty((Object)FXCollections.observableArrayList());
        messageFormatOptions.bind((ObservableValue)this.comboboxMessageFormat.itemsProperty());
        ArrayList<MessageFormat> list = new ArrayList<MessageFormat>();
        list.add(MessageFormat.STANDARD);
        list.add(MessageFormat.EXTENDED);
        ((ObservableList)messageFormatOptions.get()).setAll(list);
        this.comboboxMessageFormat.getSelectionModel().select((Object)this.model.getMessageFormat());
        this.comboboxMessageFormat.getSelectionModel().selectedItemProperty().addListener((observable, oldValue, newValue) -> {
            this.formatDescription.setText("Range: " + newValue.getRangeString());
            this.validateFields();
        });
        this.labelDataLength.setText(this.getTxDL().toString());
    }

    private void setHexPrefix(TextField textField) {
        MessageFormat numberChecker = (MessageFormat)this.comboboxMessageFormat.getSelectionModel().getSelectedItem();
        if (!textField.isFocused() && !((String)textField.textProperty().get()).startsWith("0x") && numberChecker.isNumber((String)textField.textProperty().get())) {
            textField.textProperty().set((Object)("0x" + (String)textField.textProperty().get()));
        }
    }

    private void setIdFormattingColor(Paint color) {
        this.idFormattingText.forEach(text -> text.setFill(color));
    }

    private boolean valididateMessageId(TextField textField) {
        String id;
        MessageFormat selectedFormat = (MessageFormat)this.comboboxMessageFormat.getSelectionModel().getSelectedItem();
        boolean valid = selectedFormat.isValidString(id = (String)textField.textProperty().get());
        if (valid) {
            textField.setStyle("-fx-control-inner-background: white");
        } else {
            textField.setStyle("-fx-control-inner-background: lightpink");
        }
        return valid;
    }

    private void validateFields() {
        boolean allowUpdate = true;
        allowUpdate &= this.valididateMessageId(this.tfflowIDfromDevice);
        this.settingUpdate.disableProperty().set(!(allowUpdate &= this.valididateMessageId(this.tfmsgIDtoDevice)));
    }

    private List<Integer> getTxDLOptions() {
        ArrayList<Integer> txdl = new ArrayList<Integer>();
        txdl.add(8);
        txdl.add(12);
        txdl.add(16);
        txdl.add(20);
        txdl.add(24);
        txdl.add(32);
        txdl.add(48);
        txdl.add(64);
        return txdl;
    }

    private int indexOfBitRate(List<Bitrate> list, int bitrate) {
        return list.indexOf(new Bitrate(bitrate));
    }

    private List<Bitrate> getNominalBitRateOptions() {
        ArrayList<Bitrate> list = new ArrayList<Bitrate>();
        list.add(new Bitrate(125000));
        list.add(new Bitrate(250000));
        list.add(new Bitrate(500000));
        list.add(new Bitrate(1000000));
        return list;
    }

    private List<Bitrate> getDataBitRateOptions() {
        ArrayList<Bitrate> list = new ArrayList<Bitrate>();
        list.add(new Bitrate(1538000));
        list.add(new Bitrate(2000000));
        list.add(new Bitrate(3077000));
        list.add(new Bitrate(4000000));
        list.add(new Bitrate(5000000));
        list.add(new Bitrate(6666667));
        list.add(new Bitrate(8000000));
        return list;
    }

    private void dataRateDisable(boolean disable) {
        this.comboDataBitRate.setDisable(disable);
        this.labelDataRate.setDisable(disable);
    }

    private Integer getTxDL() {
        return this.checkboxCanFd.isSelected() ? (Integer)this.comboTxDL.getValue() : Integer.valueOf(8);
    }

    private void txdlDisableFD(boolean disable) {
        this.labelTxDL.setDisable(disable);
        this.comboTxDL.setDisable(disable);
        this.labelDataLength.setText(this.getTxDL().toString());
    }

    private void updateCanFdOptions() {
        this.checkboxDataRate.setDisable(!this.checkboxCanFd.isSelected());
        this.dataRateDisable(!this.checkboxCanFd.isSelected() || !this.checkboxDataRate.isSelected());
        this.txdlDisableFD(!this.checkboxCanFd.isSelected());
    }
}

