/*
 * Decompiled with CFR 0.152.
 */
package unified.bootloader16bit.phy.can;

import java.nio.ByteBuffer;
import unified.bootloader16bit.ProtocolException;
import unified.bootloader16bit.phy.can.CanMapping;
import unified.bootloader16bit.phy.can.CanTpApi;
import unified.bootloader16bit.phy.can.DLLWrapper;

class DLLWrapperImpl
implements DLLWrapper {
    private final CanTpApi tp;

    public DLLWrapperImpl() throws ProtocolException {
        try {
            this.tp = new CanTpApi();
        }
        catch (UnsatisfiedLinkError e) {
            throw new ProtocolException("Unable to link required DLLs.  Please verify that you have downloaded the PEAK-ISO-TP.dll from https://www.peak-system.com/PCAN-ISO-TP-API.369.0.html?&L=1 and installed it into the 'lib' folder.");
        }
    }

    @Override
    public void initialize(int handle, int nominalBaudrate) {
        this.tp.initialize(handle, nominalBaudrate);
    }

    @Override
    public void initializeFd(int handle, ByteBuffer parameterString) {
        this.tp.initializeFd(handle, parameterString);
    }

    @Override
    public void setMapping(CanMapping mapping) {
        this.tp.setMapping(mapping);
    }

    @Override
    public void addMapping() {
        this.tp.addMapping();
    }

    @Override
    public void uninitialize() {
        this.tp.uninitialize();
    }

    @Override
    public void transceive(ByteBuffer in, ByteBuffer out, int timeoutMilliseconds) {
        this.tp.transceive(in, out, timeoutMilliseconds);
    }

    @Override
    public int isHardwareAvailable(int handle) {
        return this.tp.isHardwareAvailable(handle);
    }

    @Override
    public String getDllBuildDate() {
        return this.tp.getDllBuildDate();
    }

    @Override
    public String getPeakDllVersion() {
        return this.tp.getPeakDllVersion();
    }

    @Override
    public String getDllLogString() {
        return this.tp.getDllLogString();
    }

    @Override
    public int getDllLogSize() {
        return this.tp.getDllLogSize();
    }
}

