/*
 * Decompiled with CFR 0.152.
 */
package unified.bootloader16bit.phy.i2c;

import com.microchip.mcp2221.HidFeatures;
import java.nio.file.Path;
import java.nio.file.Paths;

public class LibMain {
    private final int MCP2221_VID = 1240;
    private final int MCP2221_PID = 221;

    public static void main(String[] args) {
        LibMain libMain = new LibMain();
        libMain.run();
    }

    private void run() {
        HidFeatures mcp2221 = new HidFeatures();
        int resultInt = mcp2221.Mcp2221_LoadDll();
        if (resultInt != 0) {
            System.out.println("Unable to load native DLL: " + resultInt);
            return;
        }
        System.out.println("Library Version: " + mcp2221.Mcp2221_GetLibraryVersion());
        int connectedDevices = mcp2221.Mcp2221_GetConnectedDevices(1240, 221);
        if (connectedDevices <= 0) {
            System.out.println("No connected devices matching VID=" + LibMain.toHexString(1240) + " and PID=" + LibMain.toHexString(221) + ". Error Code: " + connectedDevices);
            return;
        }
        System.out.println("Connected devices: " + connectedDevices);
        long handle = mcp2221.Mcp2221_OpenByIndex(1240, 221, 0);
        if (handle == -3L) {
            System.out.println("Error opening device index 0.");
            return;
        }
        String factorySerialNumber = mcp2221.Mcp2221_GetFactorySerialNumber(handle);
        System.out.println("Factory Serial Number: " + factorySerialNumber);
        String manufacturerDescriptor = mcp2221.Mcp2221_GetManufacturerDescriptor(handle);
        System.out.println("Manufacturer Descriptor: " + manufacturerDescriptor);
        String productDescriptor = mcp2221.Mcp2221_GetProductDescriptor(handle);
        System.out.println("Product Descriptor: " + productDescriptor);
        String serialNumberDescriptor = mcp2221.Mcp2221_GetSerialNumberDescriptor(handle);
        System.out.println("Serial Number Descriptor: " + serialNumberDescriptor);
        String hardwareRevision = mcp2221.Mcp2221_GetHardwareRevision(handle);
        System.out.println("Hardware Revision: " + hardwareRevision);
        int lastError = mcp2221.Mcp2221_GetLastError();
        System.out.println("Last Error: " + lastError);
    }

    static String toHexString(int value) {
        return "0x" + Long.toHexString(value).toUpperCase();
    }

    static {
        String userDir = System.getProperty("user.dir");
        Path userDirPath = Paths.get(userDir, new String[0]);
        Path lib = userDirPath.resolve("lib");
        if (System.getProperty("sun.arch.data.model").equals("32")) {
            try {
                System.load(lib.resolve("mcp2221_dll_um_x86.dll").toString());
                System.load(lib.resolve("libmcp2221_jni_x86.dll").toString());
            }
            catch (Exception ex) {
                System.out.println("The specified library does not exist");
            }
        } else if (System.getProperty("sun.arch.data.model").equals("64")) {
            try {
                System.load(lib.resolve("mcp2221_dll_um_x64.dll").toString());
                System.load(lib.resolve("libmcp2221_jni_x64.dll").toString());
            }
            catch (Exception ex) {
                System.out.println("The specified library does not exist");
            }
        }
    }
}

