/*
 * Decompiled with CFR 0.152.
 */
package unified.bootloader16bit.phy.lin.plin;

import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;

public enum TLINHardwareMode {
    NONE(0),
    SLAVE(1),
    MASTER(2),
    INVALID_CODE(-1);

    private static final Logger logger;
    private final int code;

    private TLINHardwareMode(int code) {
        this.code = code;
    }

    public int getCode() {
        return this.code;
    }

    public static TLINHardwareMode get(int code) {
        TLINHardwareMode modeReturn = Arrays.asList(TLINHardwareMode.values()).stream().filter(mode -> mode.getCode() == code).findFirst().orElse(INVALID_CODE);
        if (modeReturn.equals((Object)INVALID_CODE)) {
            logger.log(Level.SEVERE, "Invalid TLINHardwareMode code provided: {0}", code);
        }
        return modeReturn;
    }

    static {
        logger = Logger.getLogger(TLINHardwareMode.class.getName());
    }
}

