/*
 * Decompiled with CFR 0.152.
 */
package unified.bootloader32bit;

import com.microchip.scf.CommunicationsInterface;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.property.SimpleStringProperty;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import targetdevice.ITargetDevice;
import toplevel.TopLevelArchictecure;
import unified.MVController.IMVController;
import unified.bootloader.model32bit.UBootModel32bit;
import unified.bootloader32bit.UBootFXML32bitController;

public class UBoot32
implements TopLevelArchictecure,
ITargetDevice<UBootModel32bit> {
    public UBootModel32bit device = new UBootModel32bit();
    protected IMVController mvcController = null;
    public CommunicationsInterface commsInterface = null;
    public Parent root = null;
    Map<String, CommunicationsInterface> startupConnectedDeviceMap = new HashMap<String, CommunicationsInterface>();
    private static final Logger LOGGER = Logger.getLogger(UBoot32.class.getName());

    public void start() {
        Parent root = null;
        try {
            root = this.loadFxmlMainForm("UBootFXML32bit.fxml");
        }
        catch (IOException ex) {
            LOGGER.log(Level.SEVERE, ex.toString(), ex);
        }
        this.root = root;
    }

    private Parent loadFxmlMainForm(String file) throws IOException {
        UBootFXML32bitController form = new UBootFXML32bitController(this);
        URL location = this.getClass().getResource(file);
        FXMLLoader loader = new FXMLLoader(location);
        loader.setController((Object)form);
        Object result = loader.load();
        return (Parent)result;
    }

    @Override
    public void setDeviceName(String deviceName) {
        this.device.setDeviceName(deviceName);
    }

    @Override
    public Parent getViewer() {
        if (this.root == null) {
            this.start();
        }
        return this.root;
    }

    @Override
    public void injectModelCommunicationsController(CommunicationsInterface passedInterface) {
        try {
            this.device.setInputStream(passedInterface.getInputStream());
            this.device.setOutputStream(passedInterface.getOutputStream());
        }
        catch (IOException ex) {
            LOGGER.log(Level.SEVERE, "Should be Caught Elsewhere" + ex.toString(), ex);
        }
    }

    @Override
    public UBootModel32bit getModel() {
        return this.device;
    }

    @Override
    public void injectController(IMVController mvcController) {
        this.mvcController = mvcController;
    }

    @Override
    public void injectModelCommunicationInterface(CommunicationsInterface passedInterface) {
        try {
            this.device.setInputStream(passedInterface.getInputStream());
            this.device.setOutputStream(passedInterface.getOutputStream());
        }
        catch (IOException ex) {
            LOGGER.log(Level.SEVERE, "Should be Caught Elsewhere" + ex.toString(), ex);
        }
    }

    @Override
    public SimpleStringProperty getProtocolType() {
        return this.getModel().ubootPojo32Bit.getProtocolType();
    }

    @Override
    public void showConsole() {
        this.getModel().ubootPojo32Bit.setConsoleState(true);
    }

    @Override
    public void showProtocolSettings() {
        this.getModel().ubootPojo32Bit.setConfigurationChangedState(true);
    }

    @Override
    public void setHexFile(File file) {
        this.getModel().ubootPojo32Bit.setFileName(file.getAbsolutePath());
    }
}

