/*
 * Decompiled with CFR 0.152.
 */
package unified.bootloader8bit;

import com.microchip.scf.CommunicationsInterface;
import com.microchip.scf.softwarelibraryinterfaces.i2c.I2CSoftwareLibraryCommunicationsInterface;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.property.SimpleStringProperty;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import targetdevice.ITargetDevice;
import toplevel.TopLevelArchictecure;
import unified.MVController.IMVController;
import unified.bootloader.model.UBootModel;
import unified.bootloader8bit.UBootFXMLController;

public class UBoot
implements TopLevelArchictecure,
ITargetDevice<UBootModel> {
    public UBootModel device = new UBootModel();
    protected IMVController mvcController = null;
    protected CommunicationsInterface commsInterface = null;
    public Parent root = null;
    Map<String, CommunicationsInterface> startupConnectedDeviceMap = new HashMap<String, CommunicationsInterface>();
    private static final Logger LOGGER = Logger.getLogger(UBoot.class.getName());

    public void start() {
        Parent tmpRoot = null;
        try {
            tmpRoot = this.loadFxmlMainForm("UBootFXML.fxml");
        }
        catch (IOException ex) {
            LOGGER.log(Level.SEVERE, "8bit Start Failed. " + ex.toString(), ex);
        }
        this.root = tmpRoot;
    }

    private Parent loadFxmlMainForm(String file) throws IOException {
        UBootFXMLController form = new UBootFXMLController(this);
        URL location = this.getClass().getResource(file);
        FXMLLoader loader = new FXMLLoader(location);
        loader.setController((Object)form);
        Object result = loader.load();
        return (Parent)result;
    }

    @Override
    public void setDeviceName(String deviceName) {
        this.device.setDeviceName(deviceName);
    }

    @Override
    public Parent getViewer() {
        if (this.root == null) {
            this.start();
        }
        return this.root;
    }

    @Override
    public void injectController(IMVController mvcController) {
        this.mvcController = mvcController;
    }

    @Override
    public void injectModelCommunicationsController(CommunicationsInterface passedInterface) {
        try {
            this.device.setInputStream(passedInterface.getInputStream());
            this.device.setOutputStream(passedInterface.getOutputStream());
        }
        catch (IOException ex) {
            LOGGER.log(Level.SEVERE, "Controller Injection Failed. " + ex.toString(), ex);
        }
    }

    @Override
    public UBootModel getModel() {
        return this.device;
    }

    @Override
    public void injectModelCommunicationInterface(CommunicationsInterface passedInterface) {
        try {
            this.device.setInputStream(passedInterface.getInputStream());
            this.device.setOutputStream(passedInterface.getOutputStream());
        }
        catch (IOException ex) {
            LOGGER.log(Level.SEVERE, "Interface Injection Failed. " + ex.toString(), ex);
        }
    }

    public void injectI2CInterface(I2CSoftwareLibraryCommunicationsInterface passedI2CInterface) {
        this.device.injectI2CCommunicationInterface(passedI2CInterface);
    }

    @Override
    public SimpleStringProperty getProtocolType() {
        return this.getModel().ubootPojo.getProtocolType();
    }

    @Override
    public void showConsole() {
        this.getModel().ubootPojo.setConsoleState(true);
    }

    @Override
    public void showProtocolSettings() {
        this.getModel().ubootPojo.setConfigurationChangedState(true);
    }

    @Override
    public void setHexFile(File file) {
        this.getModel().ubootPojo.setFileName(file.getAbsolutePath());
    }
}

