/*
 * Decompiled with CFR 0.152.
 */
package i2cBootloaderController;

import com.microchip.mcu8.commandcore.ACommandBase;
import exceptionclasses.TransactionFailureException;
import exceptionclasses.ValidationException;
import i2cBootloaderModel.CommandModelWrite;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class ACommandBaseExtendedNoDataPayloadAVR
extends ACommandBase {
    protected CommandModelWrite model;
    private static final Logger LOGGER = Logger.getLogger(ACommandBaseExtendedNoDataPayloadAVR.class.getName());

    public void setCommandModel(CommandModelWrite model) {
        this.model = model;
    }

    @Override
    public int process() throws TransactionFailureException {
        this.setPacketProcessorToUse();
        while (this.retryCount != 0) {
            try {
                this.commandSpecificPacketProcessor.packPacket(this.model, this.timeOut);
                this.bootloaderOutputStream.write(this.model.data);
                LOGGER.log(Level.FINE, "READ_VER");
                for (byte b : this.model.data) {
                    LOGGER.log(Level.FINER, String.format("%02X", b));
                }
                LOGGER.log(Level.FINE, "READ_VER_DONE");
                int lengthReceived = this.bootloaderInputStream.read(this.model.dataRead);
                this.processReadDataAVR.unpackPacket(lengthReceived, this.model, this.timeOut);
                if (this.model.dataRead != null) {
                    for (byte b : this.model.dataRead) {
                        LOGGER.log(Level.FINER, String.format("%02X", b));
                    }
                }
                this.validateLevel2();
                break;
            }
            catch (ValidationException ex) {
                --this.retryCount;
                if (this.retryCount != 0) continue;
                LOGGER.log(Level.SEVERE, "Transaction Failed." + ex.whatException, ex);
                throw new TransactionFailureException("Transaction Failed." + ex.whatException);
            }
            catch (IOException ex) {
                --this.retryCount;
                if (this.retryCount != 0) continue;
                LOGGER.log(Level.SEVERE, "Transaction Failed." + ex.toString(), ex);
                throw new TransactionFailureException("Transaction Failed." + ex);
            }
        }
        return 0;
    }
}

