/*
 * Decompiled with CFR 0.152.
 */
package i2cBootloaderController.avr;

import exceptionclasses.TransactionFailureException;
import exceptionclasses.ValidationException;
import i2cBootloaderController.mcu8.ACommandBaseExtendedNoDataPayload;
import i2cBootloaderModel.CommandModelWrite;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.logging.Level;
import java.util.logging.Logger;
import packetprocessor.PacketProcessorNoDataPayloadUART;
import readFileModel.MemoryModel;

public class CommandReadVersionProtocolUART
extends ACommandBaseExtendedNoDataPayload {
    private static final Logger LOGGER = Logger.getLogger(CommandReadVersionProtocolUART.class.getName());

    public CommandReadVersionProtocolUART(InputStream commsInputStream, OutputStream commsOutputStream, MemoryModel deviceMemoryModel) {
        this.bootloaderInputStream = commsInputStream;
        this.bootloaderOutputStream = commsOutputStream;
        this.deviceMemoryModel = deviceMemoryModel;
        this.setProcessReadData();
        this.setCommandModel(new CommandModelWrite());
        this.model.command = 0;
        this.model.length = 0L;
        this.model.address = 0L;
        this.model.dataPayload = null;
        this.model.writeLength = 10;
        this.model.readLengthExpected = 26;
        this.model.allocateReadWriteBufferMemory();
    }

    @Override
    public int process() throws TransactionFailureException {
        super.process();
        this.modelBootloader.setVersion(new String(this.model.dataRead, Charset.forName("ISO-8859-1")));
        return 0;
    }

    @Override
    public int validateLevel2() throws ValidationException {
        if (this.model.dataRead[0] != 85) {
            LOGGER.log(Level.SEVERE, "Bootloader Version format not correct");
            throw new ValidationException("Bootloader Version format not correct");
        }
        if (this.model.errorStatus) {
            this.model.errorStatus = false;
            return -1;
        }
        return 0;
    }

    @Override
    protected void setPacketProcessorToUse() {
        this.commandSpecificPacketProcessor = new PacketProcessorNoDataPayloadUART();
    }
}

