/*
 * Decompiled with CFR 0.152.
 */
package readFileModel;

import i2cBootloaderModel.DeviceArchitecture;

public class MemoryModelAVRMCU8 {
    public int byteAlignedEepromMemoryOffset;
    public int byteAlignedConfigurationWordsOffset;
    public int byteAlignedBootloaderOffset;
    public int byteAlignedEraseRowSize;
    public int byteAlignedProgramMemorySize;
    public byte[] byteAlignedProgramMemory;
    public int byteAlignedConfigurationWordsSize;
    public byte[] byteAlignedConfigurationWords;
    public int byteAlignedEepromSize;
    public byte[] byteAlignedEeprom;
    public int byteAlignedWriteBlockSize = 32;
    public boolean skipErasedFlashLocations = false;
    public DeviceArchitecture deviceFamily;
    public int calculatedChecksumOnHex;

    public MemoryModelAVRMCU8(DeviceArchitecture deviceFamily) {
        this.deviceFamily = deviceFamily;
    }

    public void createProgramMemoryMap() {
        this.byteAlignedProgramMemory = new byte[this.byteAlignedProgramMemorySize];
        for (int k = 0; k < this.byteAlignedProgramMemorySize; ++k) {
            this.byteAlignedProgramMemory[k] = -1;
            if (this.deviceFamily != DeviceArchitecture.PIC16 || k % 2 == 0) continue;
            this.byteAlignedProgramMemory[k] = 63;
        }
    }

    public void createConfigurationWordsMap() {
        this.byteAlignedConfigurationWords = new byte[this.byteAlignedConfigurationWordsSize];
        for (int k = 0; k < this.byteAlignedConfigurationWordsSize; ++k) {
            this.byteAlignedConfigurationWords[k] = -1;
        }
    }

    public void createEEPROMMap() {
        this.byteAlignedEeprom = new byte[this.byteAlignedEepromSize];
        for (int k = 0; k < this.byteAlignedEepromSize; ++k) {
            this.byteAlignedEeprom[k] = -1;
        }
    }

    public void setbyteAlignedeepromMemoryOffset(int data) {
        this.byteAlignedEepromMemoryOffset = data;
    }

    public void setbyteAlignedconfigurationWordsOffset(int data) {
        this.byteAlignedConfigurationWordsOffset = data;
    }

    public void setbyteAlignedbootloaderOffset(int data) {
        this.byteAlignedBootloaderOffset = data;
    }

    public void setbyteAlignedEraseRowSize(int data) {
        this.byteAlignedEraseRowSize = data;
    }

    public void setbyteAlignedprogramMemorySize(int data) {
        this.byteAlignedProgramMemorySize = data;
    }

    public void setbyteAlignedconfigurationWordsSize(int data) {
        this.byteAlignedConfigurationWordsSize = data;
    }

    public void setbyteAlignedeepromSize(int data) {
        this.byteAlignedEepromSize = data;
    }

    public void setbyteAlignedWriteBlockSize(int data) {
        this.byteAlignedWriteBlockSize = data;
    }

    public void setskipErasedFlashLocationsFlag(boolean data) {
        this.skipErasedFlashLocations = data;
    }

    public int calculateChecksumOnFlash() {
        int itr_loop = 0;
        this.calculatedChecksumOnHex = 0;
        for (int k = 0; k < (this.byteAlignedProgramMemorySize - this.byteAlignedBootloaderOffset) / 2; ++k) {
            this.calculatedChecksumOnHex += (this.byteAlignedProgramMemory[this.byteAlignedBootloaderOffset + k + 1 + itr_loop] << 8 & 0xFF00) + (this.byteAlignedProgramMemory[this.byteAlignedBootloaderOffset + k + itr_loop] & 0xFF);
            ++itr_loop;
        }
        return this.calculatedChecksumOnHex;
    }
}

