/*
 * Decompiled with CFR 0.152.
 */
package i2cBootloaderController;

import exceptionclasses.ValidationException;
import i2cBootloaderController.ACommandBaseExtendedNoDataPayloadAVR;
import i2cBootloaderModel.CommandModelWrite;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import packetprocessor.AVR_MCU8_PacketProcessorWithDataPayloadUART;
import readFileModel.MemoryModel;

public class CommandChecksumUART_AVR
extends ACommandBaseExtendedNoDataPayloadAVR {
    private static final int CMD_INVALID = 255;
    private static final int CMD_UNSUPPORTED = 254;
    private static final int CMD_OUT_OF_RANGE = 253;
    private static final int CRC_OK = 2;
    private static final int CRC_BUSY = 1;
    private static final int CMD_LENGTH = 11;
    private static final int READ_CMD_LENGTH = 10;
    private static final int SYNCH_BYTE_POS = 0;
    private static final int SYNCH_CHARACTER = 85;
    private static final int CMD_BYTE_POS = 1;
    private static final int CRC_CKSUM_CMD = 8;
    private static final int STATUS_BYTE_POS = 10;
    private static final Logger LOGGER = Logger.getLogger(CommandChecksumUART_AVR.class.getName());

    public CommandChecksumUART_AVR(InputStream commsInputStream, OutputStream commsOutputStream, MemoryModel deviceMemoryModel) {
        this.bootloaderInputStream = commsInputStream;
        this.bootloaderOutputStream = commsOutputStream;
        this.deviceMemoryModel = deviceMemoryModel;
        this.setProcessReadDataAVR();
        this.setCommandModel(new CommandModelWrite());
        this.model.command = (byte)8;
        this.model.length = deviceMemoryModel.byteAlignedProgramMemorySize - deviceMemoryModel.byteAlignedBootloaderOffset;
        this.model.address = deviceMemoryModel.byteAlignedBootloaderOffset;
        this.model.dataPayload = null;
        this.model.writeLength = 11;
        this.model.readLengthExpected = 11;
        this.model.allocateReadWriteBufferMemory();
    }

    @Override
    public int validateLevel2() throws ValidationException {
        if (this.model.dataRead[0] != 85) {
            LOGGER.log(Level.SEVERE, "No Synch Byte before Response");
            throw new ValidationException("Malformed: No Synch Byte");
        }
        if (this.model.dataRead[1] != 8) {
            LOGGER.log(Level.SEVERE, "Bootloader CRC/CheckSum Command INCORRECT");
            throw new ValidationException("Malformed: Format not correct");
        }
        this.handleCrc(this.model.dataRead[10]);
        if (this.model.errorStatus) {
            this.model.errorStatus = false;
            return -1;
        }
        return 0;
    }

    private void handleCrc(int status) throws ValidationException {
        if (status != 2) {
            switch (status) {
                case 1: {
                    this.logError("CRC returned BUSY.");
                    break;
                }
                case -1: {
                    this.logResponseIssue("CRC Command Invalid.");
                    break;
                }
                case -3: {
                    this.logResponseIssue("CRC Command Out of Range.");
                    break;
                }
                case -2: {
                    this.logResponseIssue("CRC Command Invalid.");
                    break;
                }
                default: {
                    this.logError("CRC returned FAILURE.");
                    throw new ValidationException("CRC returned FAILURE.");
                }
            }
        }
    }

    private void logResponseIssue(String message) {
        this.logError("CRC Command Response had issue.");
        this.logError(message);
    }

    private void logError(String message) {
        LOGGER.log(Level.SEVERE, message);
    }

    @Override
    protected void setPacketProcessorToUse() {
        this.commandSpecificPacketProcessor = new AVR_MCU8_PacketProcessorWithDataPayloadUART();
    }
}

