/*
 * Decompiled with CFR 0.152.
 */
package i2cBootloaderController.mcu32;

import com.microchip.mcu8.commandcore.ACommandBase;
import exceptionclasses.TransactionFailureException;
import exceptionclasses.ValidationException;
import i2cBootloaderModel.CommandModelPIC32;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import protocol.nextchunkgetter.DataChunk;
import protocol.nextchunkgetter.IGetNextChunk;

public abstract class ACommandBaseExtendedWithDataPayloadMCU32
extends ACommandBase {
    protected CommandModelPIC32 model;
    IGetNextChunk addressIterator;
    State state = State.INIT;
    private static final Logger LOGGER = Logger.getLogger(ACommandBaseExtendedWithDataPayloadMCU32.class.getName());

    public void setCommandModel(CommandModelPIC32 model) {
        this.model = model;
    }

    protected abstract void setEraseChunckIterator();

    @Override
    public int process() throws TransactionFailureException {
        int lengthReceived = 0;
        this.setEraseChunckIterator();
        this.setPacketProcessorToUse();
        DataChunk chunk = null;
        while (this.retryCount != 0) {
            try {
                switch (this.state) {
                    case INIT: {
                        this.model.dataPayload = this.addressIterator.getData().data;
                        this.state = State.WRITE;
                    }
                    case WRITE: {
                        this.commandSpecificPacketProcessor.packPacket(this.model, this.timeOut);
                        this.bootloaderOutputStream.write(this.model.data);
                        this.state = State.READ;
                        LOGGER.log(Level.FINE, "WRITE");
                        for (byte b : this.model.data) {
                            LOGGER.log(Level.FINER, String.format("%02X", b));
                        }
                        LOGGER.log(Level.FINE, "WRITE_DONE");
                        this.modelBootloader.setConsoleText(new String(this.model.dataRead));
                        break;
                    }
                    case READ: {
                        lengthReceived = this.bootloaderInputStream.read(this.model.dataRead);
                        this.state = State.VALIDATE;
                        LOGGER.log(Level.FINE, "READ");
                        for (byte b : this.model.dataRead) {
                            LOGGER.log(Level.FINER, String.format("%02X", b));
                        }
                        LOGGER.log(Level.FINE, "READ_DONE" + lengthReceived, lengthReceived);
                        break;
                    }
                    case VALIDATE: {
                        this.processReadDataMCU32.unpackPacket(lengthReceived, this.model, this.timeOut);
                        this.validateLevel2();
                        this.state = State.ITERATE;
                        LOGGER.log(Level.FINE, "VALIDATE_SUCCESS");
                        break;
                    }
                    case ITERATE: {
                        chunk = this.addressIterator.getData();
                        if (chunk != null) {
                            this.model.dataPayload = chunk.data;
                            this.state = State.WRITE;
                            break;
                        }
                        LOGGER.log(Level.FINE, "ERASE_OVER");
                        return 0;
                    }
                }
            }
            catch (ValidationException ex) {
                --this.retryCount;
                this.state = State.WRITE;
                if (this.retryCount != 0) continue;
                LOGGER.log(Level.SEVERE, "Transaction Failed." + ex.whatException, ex);
                throw new TransactionFailureException("Transaction Failed." + ex.whatException);
            }
            catch (IOException ex) {
                --this.retryCount;
                if (this.retryCount != 0) continue;
                LOGGER.log(Level.SEVERE, "Transaction Failed." + ex.toString(), ex);
                throw new TransactionFailureException("Transaction Failed." + ex);
            }
        }
        return 0;
    }

    private static enum State {
        INIT,
        READ,
        WRITE,
        VALIDATE,
        ITERATE;

    }
}

