/*
 * Decompiled with CFR 0.152.
 */
package protocol.nextchunkgetter;

import java.util.logging.Level;
import java.util.logging.Logger;
import protocol.nextchunkgetter.DataChunk;
import protocol.nextchunkgetter.IGetNextChunk;
import readFileModel.MemoryModel;

public class GetNextEraseAddress
implements IGetNextChunk {
    int startAddress = 0;
    int address = 0;
    int programMemSize = 65536;
    boolean firstTime = true;
    int eraseRowSize = 0;
    int length = 0;
    private final MemoryModel deviceMemoryModel;
    private static final Logger LOGGER = Logger.getLogger(GetNextEraseAddress.class.getName());

    public GetNextEraseAddress(MemoryModel deviceMemoryModel) {
        this.deviceMemoryModel = deviceMemoryModel;
        this.startAddress = this.deviceMemoryModel.byteAlignedBootloaderOffset;
        this.programMemSize = this.deviceMemoryModel.byteAlignedProgramMemorySize;
        this.eraseRowSize = this.deviceMemoryModel.byteAlignedEraseRowSize;
        this.calculateLengthOfRows();
    }

    private void calculateLengthOfRows() {
        this.length = (this.programMemSize - this.startAddress) / this.eraseRowSize;
    }

    @Override
    public DataChunk getData() {
        DataChunk chunk = new DataChunk();
        if (this.firstTime) {
            this.address += this.startAddress;
            this.firstTime = false;
            chunk.address = this.address;
            chunk.length = this.length;
            return chunk;
        }
        this.address += this.length * this.eraseRowSize;
        LOGGER.log(Level.SEVERE, String.format("Address:" + this.address, new Object[0]));
        if (this.address == this.programMemSize) {
            LOGGER.log(Level.SEVERE, String.format("Address_!:" + this.address, new Object[0]));
            return null;
        }
        chunk.address = this.address;
        chunk.length = this.length;
        return chunk;
    }
}

